/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class BaseModelDataImpl
implements BaseModelData {
    protected static final FaceBakery FACE_BAKERY = new FaceBakery();
    protected final BlockModel model;
    protected final List<ResourceLocation> parents;
    protected final List<BaseModelElement> elements;

    public BaseModelDataImpl(BlockModel model, List<ResourceLocation> parents, List<BaseModelElement> elements) {
        this.model = model;
        this.parents = ImmutableList.copyOf(parents);
        this.elements = ImmutableList.copyOf(elements);
    }

    @Override
    public BlockModel getVanillaModel() {
        return this.model;
    }

    @Override
    public List<ResourceLocation> getParents() {
        return this.parents;
    }

    public List<? extends BaseModelElement> getElements() {
        return this.elements;
    }

    public void validateParents(ModelBakingContext context) {
        ArrayList<ResourceLocation> encounteredModels = new ArrayList<ResourceLocation>();
        for (ResourceLocation parent : this.parents) {
            this.validateParents(context, parent, encounteredModels);
        }
    }

    private void validateParents(ModelBakingContext context, ResourceLocation modelLocation, List<ResourceLocation> encounteredModels) {
        if (encounteredModels.contains(modelLocation)) {
            throw new IllegalStateException("Unable to bake model '" + String.valueOf(context.getModelIdentifier()) + "' due to circular dependency " + encounteredModels.stream().map(o -> "'" + String.valueOf(o) + "'").collect(Collectors.joining("->")) + "->'" + String.valueOf(modelLocation) + "'!");
        }
        encounteredModels.add(modelLocation);
        ModelInstance<?> model = context.getModel(modelLocation);
        if (model != null) {
            for (ResourceLocation dependency : model.getParentModels()) {
                this.validateParents(context, dependency, encounteredModels);
            }
        }
        encounteredModels.remove(encounteredModels.size() - 1);
    }

    public <T> T findProperty(ModelBakingContext context, Function<BlockModel, T> property, T defaultValue) {
        T value = this.findProperty(context, ModelInstance.of(DefaultModelTypes.BASE, this), property);
        return value == null ? defaultValue : value;
    }

    private <T> T findProperty(ModelBakingContext context, ModelInstance<?> model, Function<BlockModel, T> property) {
        T value;
        BlockModel vanillaModel = model.getAsVanillaModel();
        if (vanillaModel != null && (value = property.apply(vanillaModel)) != null) {
            return value;
        }
        for (ResourceLocation location : model.getParentModels()) {
            T childValue;
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null || (childValue = this.findProperty(context, dependency, property)) == null) continue;
            return childValue;
        }
        return null;
    }

    public SpriteIdentifier findParticleSprite(ModelBakingContext context) {
        ModelInstance<BaseModelDataImpl> model = ModelInstance.of(DefaultModelTypes.BASE, this);
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add("particle");
        String currentKey = "particle";
        String finalCurrentKey;
        Either either;
        while ((either = this.findProperty(context, model, arg_0 -> BaseModelDataImpl.lambda$findParticleSprite$1(finalCurrentKey = currentKey, arg_0))) != null) {
            if (either.left().isPresent()) {
                return SpriteIdentifier.of((Material)either.left().get());
            }
            currentKey = (String)either.right().get();
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
        return SpriteIdentifier.missing();
    }

    public List<BaseModelQuad> bakeQuads(ModelBakingContext context) {
        ArrayList<BaseModelQuad> quads = new ArrayList<BaseModelQuad>();
        this.bakeQuads(context, ModelInstance.of(DefaultModelTypes.BASE, this), new LinkedList(), quads::add);
        return quads;
    }

    private void bakeQuads(ModelBakingContext context, ModelInstance<?> model, Deque<ModelInstance<?>> modelStack, Consumer<BaseModelQuad> output) {
        modelStack.addLast(model);
        List<BlockElement> elements = null;
        if (model.getModelType() == DefaultModelTypes.BASE || model.getModelType() == DefaultModelTypes.CONNECTING) {
            elements = ((BaseModelDataImpl)model.getModelData()).elements;
        } else {
            BlockModel vanillaModel = model.getAsVanillaModel();
            if (vanillaModel != null) {
                elements = vanillaModel == ModelBakery.GENERATION_MARKER ? this.generateItemModel(context, modelStack) : vanillaModel.elements;
            }
        }
        if (elements != null && !elements.isEmpty()) {
            for (BlockElement element : elements) {
                for (Direction direction : element.faces.keySet()) {
                    BlockElementFace face = (BlockElementFace)element.faces.get(direction);
                    TextureAtlasSprite sprite = context.getTexture(this.resolveMaterial(context, modelStack, face.texture()));
                    BakedQuad quad = FACE_BAKERY.bakeQuad(element.from, element.to, face, sprite, direction, context.getTransformation(), element.rotation, element.shade);
                    Direction cullDirection = face.cullForDirection() != null ? Direction.rotate((Matrix4f)context.getTransformation().getRotation().getMatrix(), (Direction)face.cullForDirection()) : null;
                    Integer lightEmission = element instanceof BaseModelElement ? ((BaseModelElement)element).light_emission : null;
                    output.accept(new BaseModelQuad(quad, cullDirection, lightEmission));
                }
            }
            modelStack.pop();
            return;
        }
        for (ResourceLocation location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.bakeQuads(context, dependency, modelStack, output);
        }
        modelStack.removeLast();
    }

    protected SpriteIdentifier resolveMaterial(ModelBakingContext context, Deque<ModelInstance<?>> modelStack, String key) {
        if (key.charAt(0) == '#') {
            key = key.substring(1);
        }
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add(key);
        String currentKey = key;
        while (true) {
            Either either = null;
            for (ModelInstance<?> model2 : modelStack) {
                BlockModel vanillaModel = model2.getAsVanillaModel();
                if (vanillaModel == null) continue;
                if (vanillaModel == ModelBakery.GENERATION_MARKER && currentKey.equals("particle")) {
                    either = Either.right((Object)"layer0");
                    break;
                }
                either = (Either)vanillaModel.textureMap.get(currentKey);
                if (either == null) continue;
                break;
            }
            if (either == null) {
                String finalCurrentKey = currentKey;
                either = this.findProperty(context, modelStack.getLast(), model -> {
                    if (model == ModelBakery.GENERATION_MARKER && finalCurrentKey.equals("particle")) {
                        return Either.right((Object)"layer0");
                    }
                    return (Either)model.textureMap.get(finalCurrentKey);
                });
            }
            if (either == null) {
                return SpriteIdentifier.missing();
            }
            if (either.left().isPresent()) {
                return SpriteIdentifier.of((Material)either.left().get());
            }
            currentKey = (String)either.right().get();
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
    }

    protected List<BlockElement> generateItemModel(ModelBakingContext context, Deque<ModelInstance<?>> modelStack) {
        ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
        for (int layer = 0; layer < ItemModelGenerator.LAYERS.size(); ++layer) {
            String layerName = (String)ItemModelGenerator.LAYERS.get(layer);
            SpriteIdentifier sprite = this.resolveMaterial(context, modelStack, layerName);
            if (SpriteIdentifier.missing().equals(sprite)) break;
            SpriteContents spriteContents = context.getTexture(sprite).contents();
            elements.addAll(ModelBakery.ITEM_MODEL_GENERATOR.processFrames(layer, layerName, spriteContents));
        }
        return elements;
    }

    private static /* synthetic */ Either lambda$findParticleSprite$1(String finalCurrentKey, BlockModel m) {
        return (Either)m.textureMap.get(finalCurrentKey);
    }
}

