/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.block.RfidScannerBlock;
import me.alexdevs.classicPeripherals.item.IDataItem;
import me.alexdevs.classicPeripherals.item.ModItems;
import me.alexdevs.classicPeripherals.item.RfidBadgeItem;
import me.alexdevs.classicPeripherals.mixinInterface.ILivingEntityMixin;
import me.alexdevs.classicPeripherals.peripherals.RfidScannerPeripheral;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RfidScannerBlockEntity
extends BlockEntity {
    public static final int SCAN_TIME = 4;
    protected final RfidScannerPeripheral peripheral = new RfidScannerPeripheral(this);
    private long scanAt = 0L;
    private boolean scheduleScan = false;
    private boolean startedScan = false;

    public RfidScannerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockTiles.RFID_SCANNER.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RfidScannerBlockEntity scanner) {
        if (level.isClientSide) {
            return;
        }
        if (!scanner.scheduleScan) {
            return;
        }
        if (!scanner.startedScan) {
            scanner.getLevel().setBlockAndUpdate(pos, (BlockState)state.setValue((Property)RfidScannerBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
            scanner.startedScan = false;
        }
        if (level.getGameTime() >= scanner.scanAt) {
            scanner.scan();
            scanner.getLevel().setBlockAndUpdate(pos, (BlockState)state.setValue((Property)RfidScannerBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
            scanner.scheduleScan = false;
        }
    }

    @Nullable
    public RfidScannerPeripheral peripheral(@Nullable Direction direction) {
        return direction == null || this.getDirection() == direction ? this.peripheral : null;
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING);
    }

    public void scheduleScan() {
        this.scanAt = this.level.getGameTime() + 4L;
        this.scheduleScan = true;
        this.startedScan = true;
    }

    public void scan() {
        List<ScannedRfidBadge> badges = this.scanBadges();
        this.peripheral.emitScanEvent(badges);
    }

    private List<ScannedRfidBadge> scanBadges() {
        ArrayList<ScannedRfidBadge> badges = new ArrayList<ScannedRfidBadge>();
        Level level = this.getLevel();
        Vec3 origin = this.peripheral.getPosition();
        if (level.isClientSide) {
            return List.of();
        }
        int range = ClassicPeripherals.CONFIG.rfidScanRange;
        List<ServerPlayer> nearbyPlayers = level.players().stream().filter(player -> player.position().distanceToSqr(origin) <= (double)(range * range)).map(player -> (ServerPlayer)player).toList();
        for (ServerPlayer player2 : nearbyPlayers) {
            Inventory inventory = player2.getInventory();
            double distance = player2.position().distanceTo(origin);
            for (ItemStack stack : inventory.items) {
                Optional<String> data;
                if (!stack.is(ModItems.RFID_BADGE) || (data = IDataItem.getData(stack)).isEmpty()) continue;
                data.ifPresent(s -> badges.add(new ScannedRfidBadge((String)s, distance)));
            }
            Optional<String> equippedData = ((RfidBadgeItem)ModItems.RFID_BADGE.get()).getEquippedData(player2);
            equippedData.ifPresent(s -> badges.add(new ScannedRfidBadge((String)s, distance)));
        }
        AABB aabb = AABB.ofSize((Vec3)origin, (double)range, (double)range, (double)range);
        List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, aabb);
        for (LivingEntity livingEntity : nearbyEntities) {
            if (livingEntity instanceof Player) continue;
            double distance = livingEntity.position().distanceTo(origin);
            ILivingEntityMixin entity = (ILivingEntityMixin)livingEntity;
            Optional<String> injectedData = entity.getRfidData();
            injectedData.ifPresent(s -> badges.add(new ScannedRfidBadge((String)s, distance)));
            if (!livingEntity.isHolding((Item)ModItems.RFID_BADGE.get())) continue;
            Iterable handSlots = livingEntity.getHandSlots();
            for (ItemStack handStack : handSlots) {
                if (!handStack.is(ModItems.RFID_BADGE)) continue;
                Optional<String> data = IDataItem.getData(handStack);
                data.ifPresent(s -> badges.add(new ScannedRfidBadge((String)s, distance)));
            }
        }
        List nearbyDroppedItems = level.getEntitiesOfClass(ItemEntity.class, aabb);
        for (ItemEntity droppedItem : nearbyDroppedItems) {
            ItemStack stack = droppedItem.getItem();
            if (!stack.is((Item)ModItems.RFID_BADGE.get())) continue;
            double distance = droppedItem.position().distanceTo(origin);
            Optional<String> badgeData = IDataItem.getData(stack);
            badgeData.ifPresent(s -> badges.add(new ScannedRfidBadge((String)s, distance)));
        }
        return badges;
    }

    public record ScannedRfidBadge(String data, double distance) {
    }
}

