/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import java.util.Optional;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.NfcReaderBlock;
import me.alexdevs.classicPeripherals.item.IDataItem;
import me.alexdevs.classicPeripherals.luaApi.PocketNfcAccess;
import me.alexdevs.classicPeripherals.peripherals.NfcReaderPeripheral;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class NfcReaderBlockEntity
extends BlockEntity {
    protected final NfcReaderPeripheral peripheral = new NfcReaderPeripheral(this);
    private boolean writeMode = false;
    private String pendingWriteData = "";
    private @Nullable String pendingLabel = null;
    private boolean pendingReadOnly = false;

    public NfcReaderBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockTiles.NFC_READER.get(), pos, blockState);
    }

    public NfcReaderPeripheral peripheral() {
        return this.peripheral;
    }

    public void flagWrite(String data, @Nullable String label, Boolean flagReadOnly) {
        int maxDataSize = ClassicPeripherals.CONFIG.nfcMaxDataSize;
        this.writeMode = true;
        this.pendingWriteData = data.substring(0, Math.min(data.length(), maxDataSize));
        this.pendingLabel = label;
        this.pendingReadOnly = flagReadOnly;
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.WRITING)));
    }

    public void cancelWrite() {
        this.writeMode = false;
        this.pendingWriteData = "";
        this.pendingLabel = null;
        this.pendingReadOnly = false;
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.NONE)));
    }

    public boolean isWriteMode() {
        return this.writeMode;
    }

    public void pingRead() {
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.READING)));
        this.level.scheduleTick(this.getBlockPos(), (Block)ModBlocks.NFC_READER.get(), 10);
    }

    public void onUse(ItemStack stack) {
        if (this.writeMode) {
            boolean readOnly = IDataItem.isReadOnly(stack);
            if (readOnly) {
                this.peripheral.writeFeedback(false, "read_only");
                this.cancelWrite();
                return;
            }
            if (this.pendingLabel != null) {
                IDataItem.setLabel(stack, this.pendingLabel);
            } else {
                IDataItem.clearLabel(stack);
            }
            IDataItem.setData(stack, this.pendingWriteData);
            IDataItem.setReadOnly(stack, this.pendingReadOnly);
            this.peripheral.writeFeedback(true, "success");
            this.cancelWrite();
        } else {
            Optional<String> data = IDataItem.getData(stack);
            if (data.isPresent()) {
                this.peripheral.read(data.get());
                this.pingRead();
            }
        }
    }

    public void onPocketUse(PocketServerComputer pocket) {
        int id = pocket.getID();
        if (this.writeMode) {
            pocket.queueEvent("nfc_data", new Object[]{"internal", this.pendingWriteData});
            this.cancelWrite();
        }
        Optional<String> data = PocketNfcAccess.pop(id);
        data.ifPresent(this.peripheral::read);
    }
}

