/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.peripherals;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.AttachedComputerSet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.util.StringUtil;
import java.util.Optional;
import me.alexdevs.classicPeripherals.tiles.NfcReaderBlockEntity;
import org.jspecify.annotations.Nullable;

public class NfcReaderPeripheral
implements IPeripheral {
    private final NfcReaderBlockEntity nfcReader;
    private final AttachedComputerSet computers = new AttachedComputerSet();

    public NfcReaderPeripheral(NfcReaderBlockEntity nfcReader) {
        this.nfcReader = nfcReader;
    }

    public String getType() {
        return "nfc_reader";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable IPeripheral other) {
        if (!(other instanceof NfcReaderPeripheral)) return false;
        NfcReaderPeripheral o = (NfcReaderPeripheral)other;
        if (this.nfcReader != o.nfcReader) return false;
        return true;
    }

    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public void read(String data) {
        this.computers.forEach(computer -> computer.queueEvent("nfc_data", new Object[]{computer.getAttachmentName(), data}));
    }

    public void writeFeedback(boolean success, String message) {
        this.computers.forEach(computer -> computer.queueEvent("nfc_write", new Object[]{computer.getAttachmentName(), success, message}));
    }

    @LuaFunction(mainThread=true)
    public final void write(String data, Optional<String> label, Optional<Boolean> flagReadOnly) {
        this.nfcReader.flagWrite(data, label.map(StringUtil::normaliseLabel).orElse(null), flagReadOnly.orElse(false));
    }

    @LuaFunction(mainThread=true)
    public final boolean cancelWrite() {
        boolean inWriteMode = this.nfcReader.isWriteMode();
        this.nfcReader.cancelWrite();
        return inWriteMode;
    }
}

