/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.mixin;

import java.util.Optional;
import me.alexdevs.classicPeripherals.mixinInterface.ILivingEntityMixin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements ILivingEntityMixin {
    @Unique
    private static final String RFID_DATA_KEY = "rfidBadgeData";
    @Unique
    private String rfidBadgeData = null;

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void classicPeripherals$addData(CompoundTag compound, CallbackInfo ci) {
        if (this.rfidBadgeData != null) {
            compound.putString(RFID_DATA_KEY, this.rfidBadgeData);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void classicPeripherals$readData(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains(RFID_DATA_KEY, 8)) {
            this.rfidBadgeData = compound.getString(RFID_DATA_KEY);
        }
    }

    @Override
    public Optional<String> getRfidData() {
        return Optional.ofNullable(this.rfidBadgeData);
    }

    @Override
    public void setRfidData(@Nullable String data) {
        this.rfidBadgeData = data;
    }

    @Override
    public boolean hasRfidData() {
        return this.rfidBadgeData != null;
    }
}

