/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.mixin;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import java.util.List;
import java.util.Optional;
import me.alexdevs.classicPeripherals.luaApi.PocketNfcAccess;
import me.alexdevs.classicPeripherals.utils.PocketUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Inject(method={"interactLivingEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void classicperipherals$pocketInteractPlayer(ItemStack stack, Player source, LivingEntity target, InteractionHand usedHand, CallbackInfoReturnable<InteractionResult> cir) {
        Item self = (Item)this;
        if (!(self instanceof PocketComputerItem)) {
            return;
        }
        PocketComputerItem pocketItem = (PocketComputerItem)self;
        if (!source.isCrouching()) {
            return;
        }
        if (source.level().isClientSide()) {
            if (target instanceof Player) {
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            }
            return;
        }
        int id = PocketUtils.getServerComputer(source.getServer(), stack).getID();
        Optional<String> data = PocketNfcAccess.pop(id);
        if (data.isEmpty()) {
            cir.setReturnValue((Object)InteractionResult.PASS);
            return;
        }
        if (!(target instanceof ServerPlayer)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
            return;
        }
        ServerPlayer player = (ServerPlayer)target;
        Inventory inv = player.getInventory();
        if (inv.contains(ComputerCraftTags.Items.POCKET_COMPUTERS)) {
            List<ServerComputer> computers = PocketUtils.getAllPocketComputers(player);
            computers.forEach(computer -> computer.queueEvent("nfc_data", new Object[]{"internal", data.get()}));
        }
        cir.setReturnValue((Object)InteractionResult.CONSUME);
    }
}

