/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.item;

import java.util.List;
import java.util.Optional;
import me.alexdevs.classicPeripherals.integrations.CuriosIntegration;
import me.alexdevs.classicPeripherals.item.IDataItem;
import me.alexdevs.classicPeripherals.mixinInterface.ILivingEntityMixin;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class RfidBadgeItem
extends Item
implements IDataItem {
    public RfidBadgeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (interactionTarget instanceof Player) {
            return InteractionResult.PASS;
        }
        Optional<String> data = IDataItem.getData(stack);
        if (data.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (player.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ILivingEntityMixin entity = (ILivingEntityMixin)interactionTarget;
        entity.setRfidData(data.get());
        if (!player.getAbilities().instabuild) {
            player.getItemInHand(usedHand).shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    public Optional<String> getEquippedData(ServerPlayer player) {
        if (!CuriosIntegration.isLoaded()) {
            return Optional.empty();
        }
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curiosInventory.isEmpty()) {
            return Optional.empty();
        }
        if (!((ICuriosItemHandler)curiosInventory.get()).isEquipped((Item)this)) {
            return Optional.empty();
        }
        List equipped = ((ICuriosItemHandler)curiosInventory.get()).findCurios((Item)this);
        Optional badgeSlot = equipped.stream().findFirst();
        if (badgeSlot.isEmpty()) {
            return Optional.empty();
        }
        ItemStack stack = ((SlotResult)badgeSlot.get()).stack();
        return IDataItem.getData(stack);
    }
}

