/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.item;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.List;
import java.util.Optional;
import me.alexdevs.classicPeripherals.item.IDataItem;
import me.alexdevs.classicPeripherals.utils.PocketUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class NfcCardItem
extends Item
implements IDataItem {
    public static final String INTERNAL_SIDE = "internal";

    public NfcCardItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player source, LivingEntity target, InteractionHand usedHand) {
        if (source.level().isClientSide()) {
            if (target instanceof Player) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        Optional<String> data = IDataItem.getData(stack);
        if (data.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!(target instanceof ServerPlayer)) {
            return InteractionResult.PASS;
        }
        ServerPlayer player = (ServerPlayer)target;
        Inventory inv = player.getInventory();
        if (inv.contains(ComputerCraftTags.Items.POCKET_COMPUTERS)) {
            List<ServerComputer> computers = PocketUtils.getAllPocketComputers(player);
            computers.forEach(computer -> computer.queueEvent("nfc_data", new Object[]{INTERNAL_SIDE, data.get()}));
        }
        return InteractionResult.CONSUME;
    }
}

