/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.item;

import java.util.Optional;
import me.alexdevs.classicPeripherals.ModComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public interface IDataItem {
    public static Optional<String> getData(ItemStack stack) {
        IDataItem.tryMigrate(stack);
        String data = (String)stack.getComponents().get((DataComponentType)ModComponents.NFC_DATA.get());
        if (data == null || data.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(data);
    }

    public static void setData(ItemStack stack, String data) {
        stack.set(ModComponents.NFC_DATA, (Object)data);
    }

    public static boolean isReadOnly(ItemStack stack) {
        return (Boolean)stack.getComponents().getOrDefault((DataComponentType)ModComponents.NFC_READONLY.get(), (Object)false);
    }

    public static void setReadOnly(ItemStack stack, boolean readOnly) {
        stack.set(ModComponents.NFC_READONLY, (Object)readOnly);
    }

    public static void setLabel(ItemStack stack, String title) {
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.nullToEmpty((String)title));
    }

    public static void clearLabel(ItemStack stack) {
        stack.remove(DataComponents.CUSTOM_NAME);
    }

    public static void setColor(ItemStack stack, int color) {
        stack.set(ModComponents.NFC_COLOR, (Object)(color & 0xFFFFFF));
    }

    public static int getColor(ItemStack stack) {
        return 0xFF000000 | (Integer)stack.getComponents().getOrDefault((DataComponentType)ModComponents.NFC_COLOR.get(), (Object)0xFFFFFF);
    }

    public static boolean tryMigrate(ItemStack stack) {
        if (stack.has(ModComponents.NFC_DATA)) {
            return false;
        }
        Optional<DataItemData> legacyData = DataItemData.migrate(stack);
        if (legacyData.isEmpty()) {
            return false;
        }
        IDataItem.setData(stack, legacyData.get().data());
        IDataItem.setReadOnly(stack, legacyData.get().readonly());
        IDataItem.setColor(stack, legacyData.get().color());
        return true;
    }

    public record DataItemData(String data, boolean readonly, int color) {
        public static Optional<DataItemData> migrate(ItemStack stack) {
            if (!(stack.getItem() instanceof IDataItem)) {
                return Optional.empty();
            }
            if (!stack.has(DataComponents.CUSTOM_DATA)) {
                return Optional.empty();
            }
            CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (customData == null || customData.isEmpty()) {
                return Optional.empty();
            }
            boolean readonly = false;
            int color = 0xFFFFFF;
            CompoundTag tag = customData.copyTag();
            if (!tag.contains("data", 8)) {
                return Optional.empty();
            }
            String data = tag.getString("data");
            if (tag.contains("readOnly", 1)) {
                readonly = tag.getBoolean("readOnly");
            }
            if (tag.contains("color", 3)) {
                color = tag.getInt("color");
            }
            return Optional.of(new DataItemData(data, readonly, color));
        }
    }
}

