/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.client.model.QuantumInjectorModel;
import com.stal111.forbidden_arcanus.common.block.entity.QuantumInjectorBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class QuantumInjectorRenderer
implements BlockEntityRenderer<QuantumInjectorBlockEntity> {
    private static final ResourceLocation TEXTURE = ForbiddenArcanus.location("textures/entity/quantum_injector.png");
    private static final ResourceLocation LAYER_TEXTURE = ForbiddenArcanus.location("textures/entity/quantum_injector_layer.png");
    private final QuantumInjectorModel<?> model;

    public QuantumInjectorRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new QuantumInjectorModel(context.getModelSet());
    }

    public void render(@NotNull QuantumInjectorBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!((Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.5f, 0.5f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        this.model.setupAnim(blockEntity, 0.0f, 0.0f, (float)blockEntity.getTickCount() + partialTick, 0.0f, 0.0f);
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(this.model.renderType(TEXTURE)), packedLight, packedOverlay);
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)LAYER_TEXTURE)), packedLight, packedOverlay);
        poseStack.popPose();
    }
}

