/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;

public final class BiomeToWoodList {
    private final Map<VillagerType, List<WoodType>> map = new HashMap<VillagerType, List<WoodType>>();
    private static final Codec<Map<Holder<Biome>, List<Either<String, Fallback>>>> BIOME_TO_WOODS = Codec.unboundedMap((Codec)RegistryFixedCodec.create((ResourceKey)Registries.BIOME), (Codec)Codec.list((Codec)Codec.either((Codec)Codec.STRING, Fallback.CODEC)));
    public static final Codec<BiomeToWoodList> CODEC = BIOME_TO_WOODS.xmap(BiomeToWoodList::new, list -> new HashMap());

    public List<WoodType> getWoodsForType(VillagerType villagerType) {
        return this.map.getOrDefault(villagerType, List.of(VanillaWoodTypes.OAK));
    }

    public BiomeToWoodList(Map<Holder<Biome>, List<Either<String, Fallback>>> map) {
        for (Map.Entry<Holder<Biome>, List<Either<String, Fallback>>> e : map.entrySet()) {
            WoodType t;
            VillagerType type = VillagerType.byBiome(e.getKey());
            if (type == VillagerType.PLAINS && e.getKey().getRegisteredName().equals("minecraft:plains")) continue;
            ArrayList<String> tryAdd = new ArrayList<String>();
            ArrayList<Fallback> fallbacks = new ArrayList<Fallback>();
            for (Either<String, Fallback> v : e.getValue()) {
                if (v.left().isPresent()) {
                    tryAdd.add((String)v.left().get());
                    continue;
                }
                if (!v.right().isPresent()) continue;
                fallbacks.add((Fallback)v.right().get());
            }
            ArrayList<WoodType> woods = new ArrayList<WoodType>();
            for (String s : tryAdd) {
                t = null;
                ResourceLocation res = ResourceLocation.tryParse((String)s);
                if (res != null) {
                    t = (WoodType)WoodTypeRegistry.INSTANCE.get(ResourceLocation.parse((String)s));
                }
                if (t == null) {
                    Pattern matcher = Pattern.compile(s);
                    for (WoodType w : WoodTypeRegistry.INSTANCE) {
                        if (!matcher.matcher(w.id.toString()).find()) continue;
                        t = w;
                        break;
                    }
                }
                if (t == null) continue;
                woods.add(t);
            }
            if (woods.isEmpty()) {
                for (Fallback f : fallbacks) {
                    t = (WoodType)WoodTypeRegistry.INSTANCE.get(ResourceLocation.parse((String)f.wood));
                    if (t == null) continue;
                    woods.add(t);
                    break;
                }
            }
            if (woods.isEmpty()) continue;
            this.map.put(type, woods);
        }
    }

    private record Fallback(String wood) {
        public static final Codec<Fallback> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("fallback").forGetter(Fallback::wood)).apply((Applicative)i, Fallback::new));
    }
}

