/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.neoforge.core.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.satisfy.alpinewhispers.neoforge.core.config.AlpineWhispersClientConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Unique
    private static float alpinewhispers_cachedFogEnd = -1.0f;
    @Unique
    private static float alpinewhispers_biomeFogFactor = 0.0f;

    @Inject(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"}, at={@At(value="TAIL")})
    private static void alpinewhispers_applySnowFog(Camera camera, FogRenderer.FogMode fogMode, float viewDistance, boolean thickFog, float partialTick, CallbackInfo ci) {
        float maxEnd;
        float minEnd;
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        if (!((Boolean)AlpineWhispersClientConfig.snowFogEnabled.get()).booleanValue()) {
            alpinewhispers_cachedFogEnd = -1.0f;
            alpinewhispers_biomeFogFactor = 0.0f;
            return;
        }
        BlockPos cameraPos = camera.getBlockPosition();
        boolean isColdBiome = ((Biome)level.getBiome(cameraPos).value()).coldEnoughToSnow(cameraPos);
        float biomeTransitionSpeed = 0.05f;
        if (isColdBiome) {
            alpinewhispers_biomeFogFactor = Mth.lerp((float)biomeTransitionSpeed, (float)alpinewhispers_biomeFogFactor, (float)1.0f);
        } else if ((alpinewhispers_biomeFogFactor = Mth.lerp((float)biomeTransitionSpeed, (float)alpinewhispers_biomeFogFactor, (float)0.0f)) < 0.01f) {
            alpinewhispers_cachedFogEnd = -1.0f;
            alpinewhispers_biomeFogFactor = 0.0f;
            return;
        }
        boolean isGrove = level.getBiome(cameraPos).is(Biomes.GROVE);
        float dayTime = level.getTimeOfDay(partialTick);
        float sunHeight = 1.0f - Math.abs(dayTime - 0.5f) * 2.0f;
        boolean isSnowing = level.isRaining();
        boolean isThundering = level.isThundering();
        float clamped = FogRendererMixin.alpineWhispers$getClamped(sunHeight, isSnowing, isThundering);
        float strength = (float)((Double)AlpineWhispersClientConfig.snowFogStrength.get()).doubleValue();
        clamped = Mth.clamp((float)(clamped * strength), (float)0.0f, (float)0.95f);
        float start = 0.0f;
        long timeOfDay = level.getDayTime() % 24000L;
        if (isThundering) {
            minEnd = 3.0f;
            maxEnd = viewDistance * 0.125f;
        } else if (isSnowing) {
            minEnd = 5.5f;
            maxEnd = viewDistance * 0.45f;
        } else if (timeOfDay >= 13000L && timeOfDay <= 23000L) {
            minEnd = 3.0f;
            maxEnd = viewDistance * 0.125f;
        } else if (timeOfDay >= 6000L) {
            minEnd = 4.5f;
            maxEnd = viewDistance * 0.3f;
        } else {
            minEnd = 6.0f;
            maxEnd = viewDistance * 0.5f;
        }
        float endFactor = 1.0f - clamped;
        float targetEnd = Mth.lerp((float)endFactor, (float)minEnd, (float)maxEnd);
        if (isGrove) {
            targetEnd *= 0.7f;
        }
        if (alpinewhispers_cachedFogEnd < 0.0f) {
            alpinewhispers_cachedFogEnd = targetEnd;
        } else {
            float transitionSpeed = 0.1f;
            alpinewhispers_cachedFogEnd = Mth.lerp((float)transitionSpeed, (float)alpinewhispers_cachedFogEnd, (float)targetEnd);
        }
        float blendedEnd = Mth.lerp((float)alpinewhispers_biomeFogFactor, (float)viewDistance, (float)alpinewhispers_cachedFogEnd);
        if (thickFog) {
            blendedEnd *= 0.7f;
        }
        RenderSystem.setShaderFogStart((float)start);
        RenderSystem.setShaderFogEnd((float)blendedEnd);
    }

    @Unique
    private static float alpineWhispers$getClamped(float sunHeight, boolean isSnowing, boolean isThundering) {
        float baseStrength = 0.075f;
        float dawnDuskStrength = 0.25f;
        float nightStrength = 0.4f;
        float weatherStrength = 0.5225f;
        float timeStrength = sunHeight > 0.65f ? baseStrength : (sunHeight > 0.25f ? dawnDuskStrength : nightStrength);
        float fogStrength = timeStrength;
        if (isSnowing || isThundering) {
            fogStrength = weatherStrength;
        }
        return Mth.clamp((float)fogStrength, (float)0.01f, (float)0.95f);
    }
}

