/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.neoforge;

import java.util.Objects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.satisfy.alpinewhispers.AlpineWhispers;
import net.satisfy.alpinewhispers.core.registry.CompostableRegistry;
import net.satisfy.alpinewhispers.core.registry.EntityTypeRegistry;
import net.satisfy.alpinewhispers.neoforge.core.config.AlpineWhispersClientConfig;

@Mod(value="alpinewhispers")
public class AlpineWhispersNeoForge {
    public AlpineWhispersNeoForge(ModContainer modContainer, IEventBus modEventBus) {
        AlpineWhispers.init();
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)AlpineWhispersClientConfig.SPEC);
        Objects.requireNonNull(modContainer.getEventBus()).addListener(this::onRegisterSpawnPlacement);
        modEventBus.addListener(this::commonSetup);
    }

    private void onRegisterSpawnPlacement(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)EntityTypeRegistry.REINDEER_ENTITY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)EntityTypeRegistry.ALPINE_SHEEP_ENTITY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CompostableRegistry.init();
            AlpineWhispers.commonInit();
        });
    }
}

