/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.registry;

import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.satisfy.alpinewhispers.AlpineWhispers;
import net.satisfy.alpinewhispers.core.block.BathtubBlock;
import net.satisfy.alpinewhispers.core.block.CabinetBlock;
import net.satisfy.alpinewhispers.core.block.CandleWreathBlock;
import net.satisfy.alpinewhispers.core.block.ChairBlock;
import net.satisfy.alpinewhispers.core.block.ConnectibleCabinetBlock;
import net.satisfy.alpinewhispers.core.block.CozyBedBlock;
import net.satisfy.alpinewhispers.core.block.DresserBlock;
import net.satisfy.alpinewhispers.core.block.FairyLightsBlock;
import net.satisfy.alpinewhispers.core.block.FireplaceCorniceBlock;
import net.satisfy.alpinewhispers.core.block.FoodBlock;
import net.satisfy.alpinewhispers.core.block.FrostyBlock;
import net.satisfy.alpinewhispers.core.block.FrostySlabBlock;
import net.satisfy.alpinewhispers.core.block.FrostyStairBlock;
import net.satisfy.alpinewhispers.core.block.FrostyWallBlock;
import net.satisfy.alpinewhispers.core.block.GarlandBlock;
import net.satisfy.alpinewhispers.core.block.IcicleBlock;
import net.satisfy.alpinewhispers.core.block.PrivyBlock;
import net.satisfy.alpinewhispers.core.block.SinkBlock;
import net.satisfy.alpinewhispers.core.block.SmokeOvenBlock;
import net.satisfy.alpinewhispers.core.block.SnowGlobeBlock;
import net.satisfy.alpinewhispers.core.block.SnowyDoublePlantBlock;
import net.satisfy.alpinewhispers.core.block.SnowyGrassBlock;
import net.satisfy.alpinewhispers.core.block.SnowyLeavesBlock;
import net.satisfy.alpinewhispers.core.block.SofaBlock;
import net.satisfy.alpinewhispers.core.block.StarTopperBlock;
import net.satisfy.alpinewhispers.core.block.TableBlock;
import net.satisfy.alpinewhispers.core.block.TreeBaublesBlock;
import net.satisfy.alpinewhispers.core.block.WallWreathBlock;
import net.satisfy.alpinewhispers.core.block.WardrobeBlock;
import net.satisfy.alpinewhispers.core.block.WindowBlock;
import net.satisfy.alpinewhispers.core.item.BreadOnAStickItem;
import net.satisfy.alpinewhispers.core.item.FoodBlockItem;
import net.satisfy.alpinewhispers.core.item.TreeBaublesItem;
import net.satisfy.alpinewhispers.core.item.WinterHatItem;
import net.satisfy.alpinewhispers.core.registry.ArmorMaterialRegistry;
import net.satisfy.alpinewhispers.core.registry.EntityTypeRegistry;
import net.satisfy.alpinewhispers.core.registry.SoundEventRegistry;
import net.satisfy.alpinewhispers.core.util.GeneralUtil;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"alpinewhispers", (ResourceKey)Registries.ITEM);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"alpinewhispers", (ResourceKey)Registries.BLOCK);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Block> FROZEN_DIRT = ObjectRegistry.registerWithItem("frozen_dirt", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT)));
    public static final RegistrySupplier<Block> ICICLES = ObjectRegistry.registerWithItem("icicles", () -> new IcicleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).noOcclusion()));
    public static final RegistrySupplier<Block> ALPINE_GNEISS = ObjectRegistry.registerWithItem("alpine_gneiss", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE)));
    public static final RegistrySupplier<Block> ALPINE_GNEISS_STAIRS = ObjectRegistry.registerWithItem("alpine_gneiss_stairs", () -> new StairBlock(((Block)ALPINE_GNEISS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_STAIRS)));
    public static final RegistrySupplier<Block> ALPINE_GNEISS_SLAB = ObjectRegistry.registerWithItem("alpine_gneiss_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_SLAB)));
    public static final RegistrySupplier<Block> ALPINE_GNEISS_WALL = ObjectRegistry.registerWithItem("alpine_gneiss_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_WALL)));
    public static final RegistrySupplier<Block> ALPINE_GNEISS_BRICKS = ObjectRegistry.registerWithItem("alpine_gneiss_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE)));
    public static final RegistrySupplier<Block> ALPINE_GNEISS_BRICK_STAIRS = ObjectRegistry.registerWithItem("alpine_gneiss_brick_stairs", () -> new StairBlock(((Block)ALPINE_GNEISS_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_STAIRS)));
    public static final RegistrySupplier<Block> ALPINE_GNEISS_BRICK_SLAB = ObjectRegistry.registerWithItem("alpine_gneiss_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_SLAB)));
    public static final RegistrySupplier<Block> ALPINE_GNEISS_BRICK_WALL = ObjectRegistry.registerWithItem("alpine_gneiss_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_WALL)));
    public static final RegistrySupplier<Block> LAYERED_ALPINE_GNEISS_BRICKS = ObjectRegistry.registerWithItem("layered_alpine_gneiss_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE)));
    public static final RegistrySupplier<Block> LAYERED_ALPINE_GNEISS_BRICK_STAIRS = ObjectRegistry.registerWithItem("layered_alpine_gneiss_brick_stairs", () -> new StairBlock(((Block)LAYERED_ALPINE_GNEISS_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_STAIRS)));
    public static final RegistrySupplier<Block> LAYERED_ALPINE_GNEISS_BRICK_SLAB = ObjectRegistry.registerWithItem("layered_alpine_gneiss_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_SLAB)));
    public static final RegistrySupplier<Block> LAYERED_ALPINE_GNEISS_BRICK_WALL = ObjectRegistry.registerWithItem("layered_alpine_gneiss_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_WALL)));
    public static final RegistrySupplier<Block> MOSSY_ALPINE_GNEISS_BRICKS = ObjectRegistry.registerWithItem("mossy_alpine_gneiss_bricks", () -> new FrostyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE)));
    public static final RegistrySupplier<Block> MOSSY_ALPINE_GNEISS_BRICK_STAIRS = ObjectRegistry.registerWithItem("mossy_alpine_gneiss_brick_stairs", () -> new FrostyStairBlock(((Block)MOSSY_ALPINE_GNEISS_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_STAIRS)));
    public static final RegistrySupplier<Block> MOSSY_ALPINE_GNEISS_BRICK_SLAB = ObjectRegistry.registerWithItem("mossy_alpine_gneiss_brick_slab", () -> new FrostySlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_SLAB)));
    public static final RegistrySupplier<Block> MOSSY_ALPINE_GNEISS_BRICK_WALL = ObjectRegistry.registerWithItem("mossy_alpine_gneiss_brick_wall", () -> new FrostyWallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_WALL)));
    public static final RegistrySupplier<Block> MOSSY_LAYERED_ALPINE_GNEISS_BRICKS = ObjectRegistry.registerWithItem("mossy_layered_alpine_gneiss_bricks", () -> new FrostyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE)));
    public static final RegistrySupplier<Block> MOSSY_LAYERED_ALPINE_GNEISS_BRICK_STAIRS = ObjectRegistry.registerWithItem("mossy_layered_alpine_gneiss_brick_stairs", () -> new FrostyStairBlock(((Block)MOSSY_LAYERED_ALPINE_GNEISS_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_STAIRS)));
    public static final RegistrySupplier<Block> MOSSY_LAYERED_ALPINE_GNEISS_BRICK_SLAB = ObjectRegistry.registerWithItem("mossy_layered_alpine_gneiss_brick_slab", () -> new FrostySlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_SLAB)));
    public static final RegistrySupplier<Block> MOSSY_LAYERED_ALPINE_GNEISS_BRICK_WALL = ObjectRegistry.registerWithItem("mossy_layered_alpine_gneiss_brick_wall", () -> new FrostyWallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE_WALL)));
    public static final RegistrySupplier<Block> AROLLA_PINE_LOG = ObjectRegistry.registerWithItem("arolla_pine_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).sound(SoundType.WOOD).strength(2.0f)));
    public static final RegistrySupplier<Block> AROLLA_PINE_WOOD = ObjectRegistry.registerWithItem("arolla_pine_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).sound(SoundType.WOOD).strength(2.0f)));
    public static final RegistrySupplier<Block> STRIPPED_AROLLA_PINE_WOOD = ObjectRegistry.registerWithItem("stripped_arolla_pine_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD).sound(SoundType.WOOD).strength(2.0f)));
    public static final RegistrySupplier<Block> STRIPPED_AROLLA_PINE_LOG = ObjectRegistry.registerWithItem("stripped_arolla_pine_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG).sound(SoundType.WOOD).strength(2.0f)));
    public static final RegistrySupplier<Block> AROLLA_PINE_PLANKS = ObjectRegistry.registerWithItem("arolla_pine_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).sound(SoundType.WOOD).strength(2.0f, 3.0f).mapColor(MapColor.COLOR_BLACK)));
    public static final RegistrySupplier<Block> AROLLA_PINE_STAIRS = ObjectRegistry.registerWithItem("arolla_pine_stairs", () -> new StairBlock(((Block)AROLLA_PINE_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS)));
    public static final RegistrySupplier<Block> AROLLA_PINE_PRESSURE_PLATE = ObjectRegistry.registerWithItem("arolla_pine_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.of().noCollission().strength(0.5f).sound(SoundType.WOOD).mapColor(Blocks.SPRUCE_PLANKS.defaultMapColor())));
    public static final RegistrySupplier<Block> AROLLA_PINE_DOOR = ObjectRegistry.registerWithItem("arolla_pine_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.WOOD).noOcclusion().mapColor(Blocks.SPRUCE_PLANKS.defaultMapColor())));
    public static final RegistrySupplier<Block> AROLLA_PINE_FENCE_GATE = ObjectRegistry.registerWithItem("arolla_pine_fence_gate", () -> new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD).mapColor(Blocks.SPRUCE_PLANKS.defaultMapColor())));
    public static final RegistrySupplier<Block> AROLLA_PINE_BUTTON = ObjectRegistry.registerWithItem("arolla_pine_button", () -> ObjectRegistry.woodenButton(FeatureFlags.VANILLA));
    public static final RegistrySupplier<Block> AROLLA_PINE_SLAB = ObjectRegistry.registerWithItem("arolla_pine_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB)));
    public static final RegistrySupplier<Block> AROLLA_PINE_TRAPDOOR = ObjectRegistry.registerWithItem("arolla_pine_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR)));
    public static final RegistrySupplier<Block> AROLLA_PINE_FENCE = ObjectRegistry.registerWithItem("arolla_pine_fence", () -> new FenceBlock(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> AROLLA_PINE_WINDOW_PANE = ObjectRegistry.registerWithItem("arolla_pine_window_pane", () -> new WindowBlock(BlockBehaviour.Properties.of().strength(0.2f).randomTicks().sound(SoundType.GLASS).noOcclusion().isViewBlocking((state, world, pos) -> false).isSuffocating((state, world, pos) -> false).mapColor(MapColor.GRASS).pushReaction(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> AROLLA_PINE_WINDOW = ObjectRegistry.registerWithItem("arolla_pine_window", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).noOcclusion()));
    public static final RegistrySupplier<Block> AROLLA_PINE_LEAVES = ObjectRegistry.registerWithItem("arolla_pine_leaves", () -> new SnowyLeavesBlock(BlockBehaviour.Properties.of().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isViewBlocking((state, world, pos) -> false).isSuffocating((state, world, pos) -> false).mapColor(MapColor.GRASS)));
    public static final RegistrySupplier<Block> AROLLA_PINE_SAPLING = ObjectRegistry.registerWithItem("arolla_pine_sapling", () -> new SaplingBlock(new TreeGrower("arolla_pine_mid", Optional.empty(), Optional.of(ObjectRegistry.configuredFeatureKey("arolla_pine_mid")), Optional.empty()), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_SAPLING)));
    public static final RegistrySupplier<Block> AROLLA_PINE_BED = ObjectRegistry.registerWithItem("arolla_pine_bed", () -> new CozyBedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAY_BED).sound(SoundType.WOOD).strength(0.2f).noOcclusion()));
    public static final RegistrySupplier<Block> AROLLA_PINE_SOFA = ObjectRegistry.registerWithItem("arolla_pine_sofa", () -> new SofaBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).sound(SoundType.WOOD).mapColor(MapColor.COLOR_LIGHT_GRAY)));
    public static final RegistrySupplier<Block> AROLLA_PINE_DRESSER = ObjectRegistry.registerWithItem("arolla_pine_dresser", () -> new DresserBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS), () -> SoundEvents.WOODEN_TRAPDOOR_OPEN, () -> SoundEvents.WOODEN_TRAPDOOR_CLOSE));
    public static final RegistrySupplier<Block> AROLLA_PINE_SINK = ObjectRegistry.registerWithItem("arolla_pine_sink", () -> new SinkBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS), false));
    public static final RegistrySupplier<Block> AROLLA_PINE_WASHBASIN = ObjectRegistry.registerWithItem("arolla_pine_washbasin", () -> new SinkBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS), true));
    public static final RegistrySupplier<Block> AROLLA_PINE_CABINET = ObjectRegistry.registerWithItem("arolla_pine_cabinet", () -> new CabinetBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS), () -> SoundEvents.WOODEN_TRAPDOOR_OPEN, () -> SoundEvents.WOODEN_TRAPDOOR_CLOSE, () -> false));
    public static final RegistrySupplier<Block> AROLLA_PINE_COOKING_AISLE = ObjectRegistry.registerWithItem("arolla_pine_cooking_aisle", () -> new ConnectibleCabinetBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS), () -> SoundEvents.WOODEN_TRAPDOOR_OPEN, () -> SoundEvents.WOODEN_TRAPDOOR_CLOSE, () -> false));
    public static final RegistrySupplier<Block> AROLLA_PINE_WALL_CABINET = ObjectRegistry.registerWithItem("arolla_pine_wall_cabinet", () -> new CabinetBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS), () -> SoundEvents.WOODEN_TRAPDOOR_OPEN, () -> SoundEvents.WOODEN_TRAPDOOR_CLOSE, () -> true));
    public static final RegistrySupplier<Block> AROLLA_PINE_SMOKER = ObjectRegistry.registerWithItem("arolla_pine_smoker", () -> new SmokeOvenBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SMOKER)));
    public static final RegistrySupplier<Block> AROLLA_PINE_WARDROBE = ObjectRegistry.registerWithItem("arolla_pine_wardrobe", () -> new WardrobeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).sound(SoundType.WOOD).mapColor(MapColor.TERRACOTTA_WHITE)));
    public static final RegistrySupplier<Block> AROLLA_PINE_BATHTUB = ObjectRegistry.registerWithItem("arolla_pine_bathtub", () -> new BathtubBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).noOcclusion().strength(1.5f, 3.0f)));
    public static final RegistrySupplier<Block> AROLLA_PINE_PRIVY = ObjectRegistry.registerWithItem("arolla_pine_privy", () -> new PrivyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
    public static final RegistrySupplier<Block> AROLLA_PINE_TABLE = ObjectRegistry.registerWithItem("arolla_pine_table", () -> new TableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).pushReaction(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> AROLLA_PINE_CHAIR = ObjectRegistry.registerWithItem("arolla_pine_chair", () -> new ChairBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).pushReaction(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> FIREPLACE_CORNICE = ObjectRegistry.registerWithItem("fireplace_cornice", () -> new FireplaceCorniceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_PLANKS)));
    public static final RegistrySupplier<Block> CANDLE_WREATH = ObjectRegistry.registerWithItem("candle_wreath", () -> new CandleWreathBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSS_BLOCK)));
    public static final RegistrySupplier<Block> WALL_WREATH = ObjectRegistry.registerWithItem("wall_wreath", () -> new WallWreathBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSS_BLOCK)));
    public static final RegistrySupplier<Block> FAIRY_LIGHTS = ObjectRegistry.registerWithItem("fairy_lights", () -> new FairyLightsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLOWSTONE).emissiveRendering((state, world, pos) -> true).lightLevel(state -> 9).noOcclusion()));
    public static final RegistrySupplier<Block> GARLAND = ObjectRegistry.registerWithItem("garland", () -> new GarlandBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLOWSTONE).emissiveRendering((state, world, pos) -> true).lightLevel(state -> 4)));
    public static final RegistrySupplier<Block> STAR_TOPPER = ObjectRegistry.registerWithItem("star_topper", () -> new StarTopperBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLOWSTONE)));
    public static final RegistrySupplier<Block> TREE_BAUBLES = ObjectRegistry.registerWithoutItem("tree_baubles", () -> new TreeBaublesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLOWSTONE).emissiveRendering((state, world, pos) -> true).lightLevel(state -> 4).noOcclusion()));
    public static final RegistrySupplier<Item> TREE_BAUBLES_ITEM = ObjectRegistry.registerItem("tree_baubles", () -> new TreeBaublesItem((Block)TREE_BAUBLES.get(), new Item.Properties()));
    public static final RegistrySupplier<Item> WINTER_MAGIC_MUSIC_DISC = ObjectRegistry.registerItem("winter_magic_music_disc", () -> new Item(new Item.Properties().stacksTo(1).jukeboxPlayable(SoundEventRegistry.WINTER_MAGIC)));
    public static final RegistrySupplier<Item> REINDEER_SPAWN_EGG = ObjectRegistry.registerItem("reindeer_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.REINDEER_ENTITY, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> ALPINE_SHEEP_SPAWN_EGG = ObjectRegistry.registerItem("alpine_sheep_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.ALPINE_SHEEP_ENTITY, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> SNOW_GENTIAN = ObjectRegistry.registerWithItem("snow_gentian", () -> new FlowerBlock(MobEffects.HEAL, 1.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_TULIP)));
    public static final RegistrySupplier<Block> POTTED_SNOW_GENTIAN = ObjectRegistry.registerWithoutItem("potted_snow_gentian", () -> new FlowerPotBlock((Block)SNOW_GENTIAN.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final RegistrySupplier<Block> CHRISTMAS_ROSE = ObjectRegistry.registerWithItem("christmas_rose", () -> new FlowerBlock(MobEffects.HEAL, 1.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_TULIP)));
    public static final RegistrySupplier<Block> POTTED_CHRISTMAS_ROSE = ObjectRegistry.registerWithoutItem("potted_christmas_rose", () -> new FlowerPotBlock((Block)CHRISTMAS_ROSE.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final RegistrySupplier<Block> HOARFROST_GRASS = ObjectRegistry.registerWithItem("hoarfrost_grass", () -> new SnowyGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS)));
    public static final RegistrySupplier<Block> TALL_HOARFROST_GRASS = ObjectRegistry.registerWithItem("tall_hoarfrost_grass", () -> new SnowyDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS)));
    public static final RegistrySupplier<Block> SNOW_GLOBE = ObjectRegistry.registerWithItem("snow_globe", () -> new SnowGlobeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    public static final RegistrySupplier<Block> HOMESPUN_WOOL = ObjectRegistry.registerWithItem("homespun_wool", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_WOOL)));
    public static final RegistrySupplier<Block> HOMESPUN_CARPET = ObjectRegistry.registerWithItem("homespun_carpet", () -> new CarpetBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_CARPET)));
    public static final RegistrySupplier<Item> REINDEER = ObjectRegistry.registerItem("reindeer", () -> new Item(ObjectRegistry.getSettings().food(Foods.MUTTON)));
    public static final RegistrySupplier<Item> COOKED_REINDEER = ObjectRegistry.registerItem("cooked_reindeer", () -> new Item(ObjectRegistry.getSettings().food(Foods.COOKED_MUTTON)));
    public static final RegistrySupplier<Block> COOKED_REINDEER_DISH_BLOCK = ObjectRegistry.registerWithoutItem("cooked_reindeer_dish", () -> new FoodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), 4, new FoodProperties.Builder().nutrition(8).saturationModifier(0.9f).build()));
    public static final RegistrySupplier<Item> COOKED_REINDEER_DISH = ObjectRegistry.registerItem("cooked_reindeer_dish", () -> new FoodBlockItem((Block)COOKED_REINDEER_DISH_BLOCK.get(), ObjectRegistry.getSettings().food(Foods.GOLDEN_CARROT)));
    public static final RegistrySupplier<Item> BREAD_ON_A_STICK = ObjectRegistry.registerItem("bread_on_a_stick", () -> new BreadOnAStickItem(new Item.Properties().durability(25)));
    public static final RegistrySupplier<Item> WINTER_HAT = ObjectRegistry.registerItem("winter_hat", () -> new WinterHatItem((ArmorMaterial)ArmorMaterialRegistry.WINTER_HAT.value(), ArmorItem.Type.HELMET, ObjectRegistry.getSettings().rarity(Rarity.RARE), AlpineWhispers.identifier("textures/models/armor/winter_hat_layer_1.png")));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    public static BlockBehaviour.Properties properties(float strength) {
        return ObjectRegistry.properties(strength, strength);
    }

    public static BlockBehaviour.Properties properties(float breakSpeed, float explosionResist) {
        return BlockBehaviour.Properties.of().strength(breakSpeed, explosionResist);
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(s -> {});
    }

    private static ButtonBlock woodenButton(FeatureFlag ... featureFlags) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY);
        if (featureFlags.length > 0) {
            properties = properties.requiredFeatures(featureFlags);
        }
        return new ButtonBlock(BlockSetType.OAK, 30, properties);
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)AlpineWhispers.identifier(name));
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return GeneralUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, AlpineWhispers.identifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return GeneralUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, AlpineWhispers.identifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return GeneralUtil.registerItem(ITEMS, ITEM_REGISTRAR, AlpineWhispers.identifier(path), itemSupplier);
    }
}

