/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.item;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.alpinewhispers.core.block.entity.TreeBaublesBlockEntity;
import org.jetbrains.annotations.NotNull;

public class TreeBaublesItem
extends BlockItem {
    public TreeBaublesItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockPos;
        Level level = context.getLevel();
        BlockState originalState = level.getBlockState(blockPos = context.getClickedPos());
        if (!originalState.is(BlockTags.LEAVES)) {
            return super.useOn(context);
        }
        BlockState baublesState = this.getBlock().defaultBlockState();
        if (!level.setBlock(blockPos, baublesState, 3)) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof TreeBaublesBlockEntity) {
            TreeBaublesBlockEntity treeBaublesBlockEntity = (TreeBaublesBlockEntity)blockEntity;
            treeBaublesBlockEntity.setHeldBlock(originalState);
        }
        if (!level.isClientSide) {
            level.playSound(context.getPlayer(), blockPos, SoundEvents.AMETHYST_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            Player player = context.getPlayer();
            if (player != null && !player.getAbilities().instabuild) {
                context.getItemInHand().shrink(1);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

