/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.satisfy.alpinewhispers.core.entity.ai.AnimationAttackGoal;
import net.satisfy.alpinewhispers.core.entity.ai.EntityWithAttackAnimation;
import net.satisfy.alpinewhispers.core.registry.EntityTypeRegistry;
import net.satisfy.alpinewhispers.core.registry.SoundEventRegistry;
import org.jetbrains.annotations.NotNull;

public class ReindeerEntity
extends Donkey
implements EntityWithAttackAnimation {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(ReindeerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();

    public ReindeerEntity(EntityType<? extends ReindeerEntity> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
            this.updateAttackAnimationState();
            this.updateDeathAnimationState();
        }
    }

    private void updateAttackAnimationState() {
        boolean attacking = (Boolean)this.entityData.get(ATTACKING);
        if (attacking) {
            if (!this.attackAnimationState.isStarted()) {
                this.attackAnimationState.start(this.tickCount);
            }
        } else if (this.attackAnimationState.isStarted()) {
            this.attackAnimationState.stop();
        }
    }

    private void setupAnimationStates() {
        if (!this.idleAnimationState.isStarted()) {
            this.idleAnimationState.start(this.tickCount);
        }
    }

    protected void updateWalkAnimation(float pPartialTick) {
        float f = this.getPose() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    private void updateDeathAnimationState() {
        if (this.isDeadOrDying()) {
            if (!this.deathAnimationState.isStarted()) {
                this.deathAnimationState.start(this.tickCount);
            }
        } else if (this.deathAnimationState.isStarted()) {
            this.deathAnimationState.stop();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACKING, (Object)false);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return AbstractHorse.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.18).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.ATTACK_SPEED, 0.5).add(Attributes.ATTACK_KNOCKBACK, 1.6).add(Attributes.JUMP_STRENGTH, 0.5);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AnimationAttackGoal(this, 1.0, true, 21, 8));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 14.0f, 1.2, 1.6));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 12.0f, 1.1, 1.5));
        this.goalSelector.addGoal(4, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(8, (Goal)new ReindeerHerdGoal(this, 1.05, 18.0, 4.0));
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(12, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(Items.SWEET_BERRIES);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)EntityTypeRegistry.REINDEER_ENTITY.get()).create((Level)serverLevel);
    }

    public void travel(Vec3 travelVector) {
        if (this.isAlive()) {
            Vec3 usedVector = travelVector;
            BlockPos blockPosBelow = this.getOnPosLegacy();
            BlockState blockStateBelow = this.level().getBlockState(blockPosBelow.below());
            if (this.isSnowBlock(blockStateBelow)) {
                usedVector = new Vec3(travelVector.x * 1.125, travelVector.y, travelVector.z * 1.125);
            }
            super.travel(usedVector);
            if (this.isIceBlock(blockStateBelow) && this.onGround()) {
                Vec3 deltaMovement = this.getDeltaMovement();
                this.setDeltaMovement(deltaMovement.x * 0.6, deltaMovement.y, deltaMovement.z * 0.6);
            }
        } else {
            super.travel(travelVector);
        }
    }

    private boolean isSnowBlock(BlockState blockState) {
        return blockState.is(Blocks.SNOW) || blockState.is(Blocks.SNOW_BLOCK) || blockState.is(Blocks.POWDER_SNOW);
    }

    private boolean isIceBlock(BlockState blockState) {
        return blockState.is(Blocks.ICE) || blockState.is(Blocks.PACKED_ICE) || blockState.is(Blocks.FROSTED_ICE) || blockState.is(Blocks.BLUE_ICE);
    }

    @Override
    public LivingEntity getTarget_() {
        return this.getTarget();
    }

    @Override
    public double getMeleeAttackRangeSqr_(LivingEntity entity) {
        double width = this.getBbWidth() + entity.getBbWidth();
        return width * width;
    }

    @Override
    public void setAttacking_(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    @Override
    public Vec3 getPosition_(int index) {
        return this.position();
    }

    @Override
    public void doHurtTarget_(LivingEntity targetEntity) {
        this.doHurtTarget((Entity)targetEntity);
    }

    public boolean isSaddleable() {
        return false;
    }

    public boolean isSaddled() {
        return this.isTamed() && !this.isBaby();
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (itemStack.is(Items.SWEET_BERRIES)) {
            if (!this.level().isClientSide) {
                if (this.isBaby()) {
                    this.ageUp(ReindeerEntity.getSpeedUpSecondsWhenFeeding((int)(-this.getAge())));
                } else if (this.isTamed() && this.canFallInLove()) {
                    this.usePlayerItem(player, interactionHand, itemStack);
                    this.setInLove(player);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (!player.isSecondaryUseActive() && !this.isBaby() && this.canAddPassenger((Entity)player)) {
            if (!this.level().isClientSide) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, interactionHand);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)SoundEventRegistry.REINDEER_AMBIENT.get();
    }

    public SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundEventRegistry.REINDEER_HURT.get();
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)SoundEventRegistry.REINDEER_DEATH.get();
    }

    protected SoundEvent getAngrySound() {
        return (SoundEvent)SoundEventRegistry.REINDEER_HURT.get();
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.05f + 0.8f;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().size() < 2 && !passenger.isPassenger();
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions dimensions, float partialTick) {
        Vec3 basePos = super.getPassengerAttachmentPoint(passenger, dimensions, partialTick);
        if (!this.hasPassenger(passenger)) {
            return basePos;
        }
        int passengerIndex = this.getPassengers().indexOf(passenger);
        if (passengerIndex < 0) {
            return basePos;
        }
        float rotation = -this.getYRot() * ((float)Math.PI / 180);
        Vec3 localOffset = passengerIndex == 0 ? new Vec3(0.0, 0.0, 0.3) : new Vec3(0.0, 0.0, -0.3);
        Vec3 worldOffset = localOffset.yRot(rotation);
        return basePos.add(worldOffset);
    }

    public static class ReindeerAnimationDurations {
        public static final int ATTACK_TICKS = 21;
    }

    public static class ReindeerHerdGoal
    extends Goal {
        private final ReindeerEntity reindeer;
        private final double speedModifier;
        private final double maxDistance;
        private final double minDistance;
        private ReindeerEntity herdLeader;

        public ReindeerHerdGoal(ReindeerEntity reindeer, double speedModifier, double maxDistance, double minDistance) {
            this.reindeer = reindeer;
            this.speedModifier = speedModifier;
            this.maxDistance = maxDistance;
            this.minDistance = minDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.reindeer.isBaby()) {
                return false;
            }
            if (this.reindeer.isVehicle()) {
                return false;
            }
            List nearbyReindeer = this.reindeer.level().getEntitiesOfClass(ReindeerEntity.class, this.reindeer.getBoundingBox().inflate(this.maxDistance, 4.0, this.maxDistance), other -> other != this.reindeer && !other.isBaby() && !other.isVehicle());
            if (nearbyReindeer.isEmpty()) {
                return false;
            }
            ReindeerEntity closest = null;
            double closestDistance = Double.MAX_VALUE;
            for (ReindeerEntity candidate : nearbyReindeer) {
                double distance = this.reindeer.distanceToSqr((Entity)candidate);
                if (!(distance < closestDistance)) continue;
                closestDistance = distance;
                closest = candidate;
            }
            if (closest == null) {
                return false;
            }
            if (closestDistance <= this.minDistance * this.minDistance) {
                return false;
            }
            this.herdLeader = closest;
            return true;
        }

        public boolean canContinueToUse() {
            if (this.herdLeader == null || !this.herdLeader.isAlive()) {
                return false;
            }
            if (this.reindeer.isBaby()) {
                return false;
            }
            if (this.reindeer.isVehicle()) {
                return false;
            }
            double distance = this.reindeer.distanceToSqr((Entity)this.herdLeader);
            return distance > this.minDistance * this.minDistance && distance < this.maxDistance * this.maxDistance;
        }

        public void tick() {
            if (this.herdLeader != null) {
                this.reindeer.getNavigation().moveTo((Entity)this.herdLeader, this.speedModifier);
            }
        }

        public void stop() {
            this.herdLeader = null;
        }
    }
}

