/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.alpinewhispers.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class FireplaceCorniceBlockEntity
extends BlockEntity {
    private BlockState mimicState;

    public FireplaceCorniceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.FIRE_PLACE_CORNICE_BLOCK_ENTITY.get(), pos, state);
    }

    public BlockState getMimicState() {
        return this.mimicState;
    }

    public void setMimicState(BlockState newMimicState) {
        if (this.level == null) {
            this.mimicState = newMimicState;
            return;
        }
        this.mimicState = newMimicState;
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
            serverLevel.getChunkSource().chunkMap.getPlayers(serverLevel.getChunkAt(this.worldPosition).getPos(), false).forEach(player -> player.connection.send((Packet)packet));
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (this.mimicState != null) {
            compoundTag.put("Mimic", (Tag)NbtUtils.writeBlockState((BlockState)this.mimicState));
        }
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.mimicState = compoundTag.contains("Mimic") ? NbtUtils.readBlockState((HolderGetter)provider.lookupOrThrow(Registries.BLOCK), (CompoundTag)compoundTag.getCompound("Mimic")) : null;
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        if (this.mimicState != null) {
            tag.put("Mimic", (Tag)NbtUtils.writeBlockState((BlockState)this.mimicState));
        }
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

