/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.alpinewhispers.core.block.BathtubBlock;
import net.satisfy.alpinewhispers.core.registry.EntityTypeRegistry;
import net.satisfy.alpinewhispers.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class BathtubBlockEntity
extends BlockEntity {
    private int total;
    private int progress;
    private int clientProgress;
    private boolean filling;

    public BathtubBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.BATHTUB_BLOCK_ENTITY.get(), pos, state);
    }

    private void setFullFlag(boolean full) {
        Level l = this.level;
        if (l == null) {
            return;
        }
        BlockState s = l.getBlockState(this.worldPosition);
        if (s.hasProperty((Property)BathtubBlock.FULL) && (Boolean)s.getValue((Property)BathtubBlock.FULL) != full) {
            l.setBlock(this.worldPosition, (BlockState)s.setValue((Property)BathtubBlock.FULL, (Comparable)Boolean.valueOf(full)), 2);
        }
    }

    public void startFilling(int totalTicks) {
        this.total = totalTicks;
        this.progress = 0;
        this.clientProgress = 0;
        this.filling = true;
        this.setFullFlag(false);
        this.setChanged();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BathtubBlockEntity be) {
        if (!be.filling || be.total <= 0) {
            return;
        }
        ++be.progress;
        be.setChanged();
        if (be.progress % 10 == 0) {
            level.playSound(null, pos, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, 0.25f, 0.9f + level.random.nextFloat() * 0.2f);
        }
        if (be.progress % 20 == 0) {
            level.playSound(null, pos, SoundEvents.AMBIENT_UNDERWATER_ENTER, SoundSource.BLOCKS, 0.35f, 0.95f + level.random.nextFloat() * 0.1f);
        }
        if (be.progress % 5 == 0) {
            level.sendBlockUpdated(pos, state, state, 2);
        }
        if (be.progress >= be.total) {
            be.progress = be.total;
            be.filling = false;
            be.setFullFlag(true);
            level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 0.7f, 1.0f);
            level.sendBlockUpdated(pos, state, state, 2);
        }
    }

    public static void clientTick(BathtubBlockEntity be) {
        if (be.clientProgress < be.progress) {
            ++be.clientProgress;
        }
    }

    public float getFillRatio(float partial) {
        if (this.total <= 0) {
            return 0.0f;
        }
        float cp = this.clientProgress;
        float sp = this.progress;
        float p = cp + (sp - cp) * Mth.clamp((float)partial, (float)0.0f, (float)1.0f);
        return Mth.clamp((float)(p / (float)this.total), (float)0.0f, (float)1.0f);
    }

    public boolean isFilling() {
        return this.filling;
    }

    public boolean isFilled() {
        return this.total > 0 && this.progress >= this.total;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("total", this.total);
        tag.putInt("progress", this.progress);
        tag.putBoolean("filling", this.filling);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.total = tag.getInt("total");
        this.progress = tag.getInt("progress");
        this.filling = tag.getBoolean("filling");
        this.clientProgress = this.progress;
        Level l = this.level;
        if (l instanceof ServerLevel) {
            this.setFullFlag(this.total > 0 && this.progress >= this.total);
        }
    }

    public boolean canDrainPercent(float percent) {
        if (this.total <= 0) {
            return false;
        }
        int amt = Mth.floor((float)((float)this.total * percent + 0.5f));
        return amt > 0 && this.progress >= amt;
    }

    public boolean drainPercent(float percent) {
        if (this.total <= 0) {
            return false;
        }
        int amt = Mth.floor((float)((float)this.total * percent + 0.5f));
        if (amt <= 0 || this.progress < amt) {
            return false;
        }
        this.progress -= amt;
        if (this.progress < this.total) {
            this.setFullFlag(false);
        }
        if (this.progress == 0) {
            this.filling = false;
        }
        this.setChanged();
        Level l = this.level;
        if (l != null) {
            l.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
        return true;
    }

    public void setChanged() {
        Level l = this.level;
        if (l instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)l;
            if (!l.isClientSide()) {
                ClientboundBlockEntityDataPacket pkt = this.getUpdatePacket();
                for (ServerPlayer p : GeneralUtil.tracking(s, this.worldPosition)) {
                    p.connection.send((Packet)pkt);
                }
            }
        }
        super.setChanged();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

