/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.alpinewhispers.core.block.entity.WardrobeBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WardrobeBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<WardrobeBlock> CODEC = WardrobeBlock.simpleCodec(WardrobeBlock::new);
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    public WardrobeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @NotNull
    protected MapCodec<? extends WardrobeBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        Level level = ctx.getLevel();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(ctx)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf half;
        BlockPos other;
        BlockState otherState;
        BlockEntity be;
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER && (be = level.getBlockEntity(pos)) instanceof WardrobeBlockEntity) {
            WardrobeBlockEntity wardrobe = (WardrobeBlockEntity)be;
            for (ItemStack s : wardrobe.getInventory()) {
                if (s.isEmpty()) continue;
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)s.copy());
            }
        }
        if ((otherState = level.getBlockState(other = (half = (DoubleBlockHalf)state.getValue(HALF)) == DoubleBlockHalf.LOWER ? pos.above() : pos.below())).is((Block)this) && otherState.getValue(HALF) != half) {
            level.destroyBlock(other, !player.isCreative());
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, HALF});
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos bePos = state.getValue(HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos;
        BlockEntity be = level.getBlockEntity(bePos);
        if (!(be instanceof WardrobeBlockEntity)) {
            return InteractionResult.PASS;
        }
        WardrobeBlockEntity wardrobe = (WardrobeBlockEntity)be;
        if (player.isShiftKeyDown()) {
            for (int i = 0; i < wardrobe.getInventory().size(); ++i) {
                ItemStack stored = wardrobe.getItem(i);
                if (stored.isEmpty()) continue;
                player.addItem(stored.copy());
                wardrobe.setStack(i, ItemStack.EMPTY);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        this.toggleOpen(level, bePos);
        return InteractionResult.CONSUME;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockPos bePos = state.getValue(HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos;
        BlockEntity be = level.getBlockEntity(bePos);
        if (!(be instanceof WardrobeBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        WardrobeBlockEntity wardrobe = (WardrobeBlockEntity)be;
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            int index;
            ArmorItem armor = (ArmorItem)item;
            switch (armor.getEquipmentSlot()) {
                case HEAD: {
                    int n = 0;
                    break;
                }
                case CHEST: {
                    int n = 1;
                    break;
                }
                case LEGS: {
                    int n = 2;
                    break;
                }
                case FEET: {
                    int n = 3;
                    break;
                }
                default: {
                    int n = index = -1;
                }
            }
            if (index >= 0) {
                ItemStack existing = wardrobe.getItem(index);
                wardrobe.setStack(index, stack.copyWithCount(1));
                player.getItemInHand(hand).shrink(1);
                if (!existing.isEmpty()) {
                    player.addItem(existing);
                }
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void toggleOpen(Level level, BlockPos basePos) {
        BlockState state = level.getBlockState(basePos);
        if (!state.is((Block)this)) {
            return;
        }
        boolean open = (Boolean)state.getValue((Property)OPEN) == false;
        level.setBlock(basePos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
        BlockPos otherPos = basePos.above();
        BlockState other = level.getBlockState(otherPos);
        if (other.is((Block)this)) {
            level.setBlock(otherPos, (BlockState)other.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
        level.playSound(null, basePos, open ? SoundEvents.WOODEN_DOOR_OPEN : SoundEvents.WOODEN_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        VoxelShape legs = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)2.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)16.0)});
        VoxelShape body = Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        return Shapes.or((VoxelShape)legs, (VoxelShape)body);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WardrobeBlockEntity(pos, state);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.wardrobe.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.wardrobe.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

