/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class StarTopperBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public StarTopperBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> 14));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        if (randomSource.nextFloat() < 0.15f) {
            double baseX = (double)pos.getX() + 0.5;
            double baseY = (double)pos.getY() + 1.15;
            double baseZ = (double)pos.getZ() + 0.5;
            double angle = randomSource.nextDouble() * Math.PI * 2.0;
            double radius = 0.25 + randomSource.nextDouble() * 0.15;
            double x = baseX + Math.cos(angle) * radius;
            double z = baseZ + Math.sin(angle) * radius;
            double y = baseY + randomSource.nextDouble() * 0.08;
            double velocityX = (randomSource.nextDouble() - 0.5) * 0.01;
            double velocityY = 0.03 + randomSource.nextDouble() * 0.02;
            double velocityZ = (randomSource.nextDouble() - 0.5) * 0.01;
            level.addParticle((ParticleOptions)ParticleTypes.END_ROD, x, y, z, velocityX, velocityY, velocityZ);
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.canbeplaced").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

