/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.alpinewhispers.core.block.LineConnectingBlock;
import net.satisfy.alpinewhispers.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class SofaBlock
extends LineConnectingBlock {
    public static final Map<Direction, VoxelShape> SHAPE;
    public static final Map<Direction, VoxelShape> MIDDLE_SHAPE;
    public static final Map<Direction, VoxelShape> LEFT_SHAPE;
    public static final Map<Direction, VoxelShape> RIGHT_SHAPE;
    private static final Supplier<VoxelShape> noneShapeSupplier;
    private static final Supplier<VoxelShape> middleShapeSupplier;
    private static final Supplier<VoxelShape> leftShapeSupplier;
    private static final Supplier<VoxelShape> rightShapeSupplier;

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (switch ((GeneralUtil.LineConnectingType)((Object)state.getValue((Property)TYPE))) {
            case GeneralUtil.LineConnectingType.MIDDLE -> MIDDLE_SHAPE;
            case GeneralUtil.LineConnectingType.LEFT -> LEFT_SHAPE;
            case GeneralUtil.LineConnectingType.RIGHT -> RIGHT_SHAPE;
            default -> SHAPE;
        }).get(state.getValue((Property)FACING));
    }

    public SofaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return GeneralUtil.onUse(level, player, interactionHand, blockHitResult, -0.3);
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(world, state, pos, entity, fallDistance * 0.5f);
    }

    public void updateEntityAfterFallOn(BlockGetter world, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(world, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 motion = entity.getDeltaMovement();
        if (motion.y < 0.0) {
            double bounceFactor = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(motion.x, -motion.y * 0.66 * bounceFactor, motion.z);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        GeneralUtil.onStateReplaced(world, pos);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    static {
        noneShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.375, (double)0.003125, (double)1.0625, (double)0.75, (double)0.99375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.0625, (double)0.375, (double)0.003125, (double)0.1875, (double)0.75, (double)0.99375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.125, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        middleShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        leftShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.375, (double)0.0, (double)0.3125, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.125, (double)0.0, (double)1.0, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.0625, (double)0.3125, (double)0.125, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.8125, (double)0.3125, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        rightShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.4375, (double)0.75, (double)0.875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.375, (double)0.0, (double)0.9375, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.0, (double)0.875, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.0, (double)0.0625, (double)0.8125, (double)0.125, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.0, (double)0.8125, (double)0.8125, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, noneShapeSupplier.get()));
            }
        });
        MIDDLE_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, middleShapeSupplier.get()));
            }
        });
        LEFT_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, leftShapeSupplier.get()));
            }
        });
        RIGHT_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, rightShapeSupplier.get()));
            }
        });
    }
}

