/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SnowGlobeBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final MapCodec<SnowGlobeBlock> CODEC = SnowGlobeBlock.simpleCodec(SnowGlobeBlock::new);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), (VoxelShape)Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875));

    public SnowGlobeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public MapCodec<SnowGlobeBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)POWER, (Comparable)Integer.valueOf(0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWER});
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        int currentPower = (Integer)blockState.getValue((Property)POWER);
        int nextPower = Math.min(15, currentPower + 5);
        if (nextPower != currentPower) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWER, (Comparable)Integer.valueOf(nextPower)), 3);
            level.scheduleTick(blockPos, (Block)this, 4);
        }
        return InteractionResult.CONSUME;
    }

    public void tick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        int currentPower = (Integer)blockState.getValue((Property)POWER);
        if (currentPower <= 0) {
            return;
        }
        int nextPower = currentPower - 1;
        level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWER, (Comparable)Integer.valueOf(nextPower)), 3);
        if (nextPower > 0) {
            level.scheduleTick(blockPos, (Block)this, 4);
        }
    }

    public boolean isSignalSource(BlockState blockState) {
        return (Integer)blockState.getValue((Property)POWER) > 0;
    }

    public int getSignal(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return (Integer)blockState.getValue((Property)POWER);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (!level.isClientSide) {
            return;
        }
        int power = (Integer)blockState.getValue((Property)POWER);
        if (power <= 0) {
            return;
        }
        if (!level.getBlockState(blockPos.below()).isSolid()) {
            return;
        }
        double intensity = Math.min(1.0, (double)power / 15.0);
        int particleCount = 1 + (int)(intensity * 4.0);
        double minX = (double)blockPos.getX() + 0.25;
        double maxX = (double)blockPos.getX() + 0.75;
        double minY = (double)blockPos.getY() + 0.25;
        double maxY = (double)blockPos.getY() + 0.75;
        double minZ = (double)blockPos.getZ() + 0.25;
        double maxZ = (double)blockPos.getZ() + 0.75;
        double baseSpeed = 0.002 + intensity * 0.003;
        for (int i = 0; i < particleCount; ++i) {
            double x = minX + randomSource.nextDouble() * (maxX - minX);
            double y = minY + randomSource.nextDouble() * (maxY - minY);
            double z = minZ + randomSource.nextDouble() * (maxZ - minZ);
            double motionX = (randomSource.nextDouble() - 0.5) * baseSpeed;
            double motionZ = (randomSource.nextDouble() - 0.5) * baseSpeed;
            double motionY = -0.002 - randomSource.nextDouble() * baseSpeed * 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, x, y, z, motionX, motionY, motionZ);
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.canbeplaced").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

