/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.alpinewhispers.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GarlandBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<GarlandType> TYPE = EnumProperty.create((String)"type", GarlandType.class);
    public static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public GarlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)GarlandType.NONE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return SHAPES.getOrDefault(facing, SHAPES.get(Direction.NORTH));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos wallPos = pos.relative(facing.getOpposite());
        BlockState wallState = level.getBlockState(wallPos);
        if (GarlandBlock.canAttachTo(wallState, level, wallPos, facing)) {
            return true;
        }
        BlockPos ceilingPos = pos.above();
        BlockState ceilingState = level.getBlockState(ceilingPos);
        return GarlandBlock.canAttachTo(ceilingState, level, ceilingPos, Direction.DOWN);
    }

    private static boolean canAttachTo(BlockState blockState, LevelReader levelReader, BlockPos blockPos, Direction face) {
        return !blockState.isAir();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] directions;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        for (Direction direction : directions = context.getNearestLookingDirections()) {
            BlockState candidate;
            if (!direction.getAxis().isHorizontal() || !(candidate = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite())).setValue(TYPE, (Comparable)((Object)GarlandType.NONE))).canSurvive((LevelReader)level, pos)) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (direction.getOpposite() == facing && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        GarlandType newType = this.resolveType(state, level, pos);
        if (newType != state.getValue(TYPE)) {
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)newType));
        }
        return state;
    }

    private GarlandType resolveType(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction leftDirection = facing.getCounterClockWise();
        Direction rightDirection = facing.getClockWise();
        BlockState leftState = level.getBlockState(pos.relative(leftDirection));
        BlockState rightState = level.getBlockState(pos.relative(rightDirection));
        boolean hasLeft = leftState.is((Block)this);
        boolean hasRight = rightState.is((Block)this);
        if (hasLeft && hasRight && leftState.getValue((Property)FACING) == facing && rightState.getValue((Property)FACING) == facing) {
            return GarlandType.STRAIGHT;
        }
        if (hasLeft) {
            Direction leftFacing = (Direction)leftState.getValue((Property)FACING);
            if (leftFacing == leftDirection) {
                return GarlandType.OUTER_LEFT;
            }
            if (leftFacing == leftDirection.getOpposite()) {
                return GarlandType.INNER_LEFT;
            }
            if (leftFacing == facing) {
                return GarlandType.STRAIGHT;
            }
        }
        if (hasRight) {
            Direction rightFacing = (Direction)rightState.getValue((Property)FACING);
            if (rightFacing == rightDirection) {
                return GarlandType.OUTER_RIGHT;
            }
            if (rightFacing == rightDirection.getOpposite()) {
                return GarlandType.INNER_RIGHT;
            }
            if (rightFacing == facing) {
                return GarlandType.STRAIGHT;
            }
        }
        return GarlandType.NONE;
    }

    private static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.6875, (double)0.75, (double)1.0, (double)0.9375, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.6875, (double)0.6875, (double)0.25, (double)0.8125, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.8125, (double)0.6875, (double)0.5625, (double)0.9375, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.75, (double)0.6875, (double)0.875, (double)0.875, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.canbeplacedonwalls").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }

    static {
        VoxelShape baseShape = GarlandBlock.makeShape();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            SHAPES.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, baseShape));
        }
    }

    public static enum GarlandType implements StringRepresentable
    {
        NONE("none"),
        STRAIGHT("straight"),
        INNER_LEFT("inner_left"),
        INNER_RIGHT("inner_right"),
        OUTER_LEFT("outer_left"),
        OUTER_RIGHT("outer_right");

        private final String name;

        private GarlandType(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

