/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.alpinewhispers.core.block.FrostyBlockInterface;
import org.jetbrains.annotations.NotNull;

public class FrostyWallBlock
extends Block
implements SimpleWaterloggedBlock,
FrostyBlockInterface {
    public static final MapCodec<FrostyWallBlock> CODEC = FrostyWallBlock.simpleCodec(FrostyWallBlock::new);
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final EnumProperty<WallSide> EAST_WALL = BlockStateProperties.EAST_WALL;
    public static final EnumProperty<WallSide> NORTH_WALL = BlockStateProperties.NORTH_WALL;
    public static final EnumProperty<WallSide> SOUTH_WALL = BlockStateProperties.SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST_WALL = BlockStateProperties.WEST_WALL;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;
    private static final VoxelShape POST_TEST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape NORTH_TEST = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_TEST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TEST = Block.box((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_TEST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    @NotNull
    public MapCodec<FrostyWallBlock> codec() {
        return CODEC;
    }

    public FrostyWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue(NORTH_WALL, (Comparable)WallSide.NONE)).setValue(EAST_WALL, (Comparable)WallSide.NONE)).setValue(SOUTH_WALL, (Comparable)WallSide.NONE)).setValue(WEST_WALL, (Comparable)WallSide.NONE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FrostyBlockInterface.FROSTY, (Comparable)Boolean.valueOf(false)));
        this.shapeByIndex = this.makeShapes(16.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(24.0f, 24.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape voxelShape, WallSide wallSide, VoxelShape low, VoxelShape tall) {
        if (wallSide == WallSide.TALL) {
            return Shapes.or((VoxelShape)voxelShape, (VoxelShape)tall);
        }
        return wallSide == WallSide.LOW ? Shapes.or((VoxelShape)voxelShape, (VoxelShape)low) : voxelShape;
    }

    private Map<BlockState, VoxelShape> makeShapes(float h, float j, float k) {
        float l = 4.0f;
        float m = 12.0f;
        float n = 5.0f;
        float o = 11.0f;
        VoxelShape post = Block.box((double)l, (double)0.0, (double)l, (double)m, (double)h, (double)m);
        VoxelShape northLow = Block.box((double)n, (double)0.0, (double)0.0, (double)o, (double)j, (double)o);
        VoxelShape southLow = Block.box((double)n, (double)0.0, (double)n, (double)o, (double)j, (double)16.0);
        VoxelShape westLow = Block.box((double)0.0, (double)0.0, (double)n, (double)o, (double)j, (double)o);
        VoxelShape eastLow = Block.box((double)n, (double)0.0, (double)n, (double)16.0, (double)j, (double)o);
        VoxelShape northTall = Block.box((double)n, (double)0.0, (double)0.0, (double)o, (double)k, (double)o);
        VoxelShape southTall = Block.box((double)n, (double)0.0, (double)n, (double)o, (double)k, (double)16.0);
        VoxelShape westTall = Block.box((double)0.0, (double)0.0, (double)n, (double)o, (double)k, (double)o);
        VoxelShape eastTall = Block.box((double)n, (double)0.0, (double)n, (double)16.0, (double)k, (double)o);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean frosty : FrostyBlockInterface.FROSTY.getPossibleValues()) {
            for (Boolean up : UP.getPossibleValues()) {
                for (WallSide east : EAST_WALL.getPossibleValues()) {
                    for (WallSide north : NORTH_WALL.getPossibleValues()) {
                        for (WallSide west : WEST_WALL.getPossibleValues()) {
                            for (WallSide south : SOUTH_WALL.getPossibleValues()) {
                                VoxelShape shape = Shapes.empty();
                                shape = FrostyWallBlock.applyWallShape(shape, east, eastLow, eastTall);
                                shape = FrostyWallBlock.applyWallShape(shape, west, westLow, westTall);
                                shape = FrostyWallBlock.applyWallShape(shape, north, northLow, northTall);
                                shape = FrostyWallBlock.applyWallShape(shape, south, southLow, southTall);
                                if (up.booleanValue()) {
                                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)post);
                                }
                                BlockState baseState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FrostyBlockInterface.FROSTY, (Comparable)frosty)).setValue((Property)UP, (Comparable)up)).setValue(EAST_WALL, (Comparable)east)).setValue(WEST_WALL, (Comparable)west)).setValue(NORTH_WALL, (Comparable)north)).setValue(SOUTH_WALL, (Comparable)south);
                                builder.put((Object)((BlockState)baseState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)shape);
                                builder.put((Object)((BlockState)baseState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)shape);
                            }
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    @NotNull
    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        VoxelShape voxelShape = this.shapeByIndex.get(blockState);
        return voxelShape == null ? Shapes.empty() : voxelShape;
    }

    @NotNull
    protected VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        VoxelShape voxelShape = this.collisionShapeByIndex.get(blockState);
        return voxelShape == null ? Shapes.empty() : voxelShape;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    private boolean connectsTo(BlockState blockState, boolean sturdy, Direction direction) {
        Block block = blockState.getBlock();
        boolean gate = block instanceof FenceGateBlock && FenceGateBlock.connectsToDirection((BlockState)blockState, (Direction)direction);
        return blockState.is(BlockTags.WALLS) || !Block.isExceptionForConnection((BlockState)blockState) && sturdy || block instanceof IronBarsBlock || gate;
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Level levelReader = blockPlaceContext.getLevel();
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        FluidState fluidState = blockPlaceContext.getLevel().getFluidState(blockPlaceContext.getClickedPos());
        BlockPos northPos = blockPos.north();
        BlockPos eastPos = blockPos.east();
        BlockPos southPos = blockPos.south();
        BlockPos westPos = blockPos.west();
        BlockPos abovePos = blockPos.above();
        BlockState northState = levelReader.getBlockState(northPos);
        BlockState eastState = levelReader.getBlockState(eastPos);
        BlockState southState = levelReader.getBlockState(southPos);
        BlockState westState = levelReader.getBlockState(westPos);
        BlockState aboveState = levelReader.getBlockState(abovePos);
        boolean northConnect = this.connectsTo(northState, northState.isFaceSturdy((BlockGetter)levelReader, northPos, Direction.SOUTH), Direction.SOUTH);
        boolean eastConnect = this.connectsTo(eastState, eastState.isFaceSturdy((BlockGetter)levelReader, eastPos, Direction.WEST), Direction.WEST);
        boolean southConnect = this.connectsTo(southState, southState.isFaceSturdy((BlockGetter)levelReader, southPos, Direction.NORTH), Direction.NORTH);
        boolean westConnect = this.connectsTo(westState, westState.isFaceSturdy((BlockGetter)levelReader, westPos, Direction.EAST), Direction.EAST);
        BlockState base = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue((Property)FrostyBlockInterface.FROSTY, (Comparable)Boolean.valueOf(false));
        return this.updateShape((LevelReader)levelReader, base, abovePos, aboveState, northConnect, eastConnect, southConnect, westConnect);
    }

    @NotNull
    protected BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        if (direction == Direction.DOWN) {
            return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
        }
        if (direction == Direction.UP) {
            return this.topUpdate((LevelReader)levelAccessor, blockState, blockPos2, blockState2);
        }
        return this.sideUpdate((LevelReader)levelAccessor, blockPos, blockState, blockPos2, blockState2, direction);
    }

    private static boolean isConnected(BlockState blockState, Property<WallSide> property) {
        return blockState.getValue(property) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape shape, VoxelShape test) {
        return !Shapes.joinIsNotEmpty((VoxelShape)test, (VoxelShape)shape, (BooleanOp)BooleanOp.ONLY_FIRST);
    }

    private BlockState topUpdate(LevelReader levelReader, BlockState blockState, BlockPos blockPos, BlockState blockState2) {
        boolean north = FrostyWallBlock.isConnected(blockState, NORTH_WALL);
        boolean east = FrostyWallBlock.isConnected(blockState, EAST_WALL);
        boolean south = FrostyWallBlock.isConnected(blockState, SOUTH_WALL);
        boolean west = FrostyWallBlock.isConnected(blockState, WEST_WALL);
        return this.updateShape(levelReader, blockState, blockPos, blockState2, north, east, south, west);
    }

    private BlockState sideUpdate(LevelReader levelReader, BlockPos blockPos, BlockState blockState, BlockPos blockPos2, BlockState blockState2, Direction direction) {
        Direction opposite = direction.getOpposite();
        boolean north = direction == Direction.NORTH ? this.connectsTo(blockState2, blockState2.isFaceSturdy((BlockGetter)levelReader, blockPos2, opposite), opposite) : FrostyWallBlock.isConnected(blockState, NORTH_WALL);
        boolean east = direction == Direction.EAST ? this.connectsTo(blockState2, blockState2.isFaceSturdy((BlockGetter)levelReader, blockPos2, opposite), opposite) : FrostyWallBlock.isConnected(blockState, EAST_WALL);
        boolean south = direction == Direction.SOUTH ? this.connectsTo(blockState2, blockState2.isFaceSturdy((BlockGetter)levelReader, blockPos2, opposite), opposite) : FrostyWallBlock.isConnected(blockState, SOUTH_WALL);
        boolean west = direction == Direction.WEST ? this.connectsTo(blockState2, blockState2.isFaceSturdy((BlockGetter)levelReader, blockPos2, opposite), opposite) : FrostyWallBlock.isConnected(blockState, WEST_WALL);
        BlockPos abovePos = blockPos.above();
        BlockState aboveState = levelReader.getBlockState(abovePos);
        return this.updateShape(levelReader, blockState, abovePos, aboveState, north, east, south, west);
    }

    private BlockState updateShape(LevelReader levelReader, BlockState blockState, BlockPos blockPos, BlockState blockState2, boolean north, boolean east, boolean south, boolean west) {
        VoxelShape topShape = blockState2.getCollisionShape((BlockGetter)levelReader, blockPos).getFaceShape(Direction.DOWN);
        BlockState updated = this.updateSides(blockState, north, east, south, west, topShape);
        return (BlockState)updated.setValue((Property)UP, (Comparable)Boolean.valueOf(this.shouldRaisePost(updated, blockState2, topShape)));
    }

    private boolean shouldRaisePost(BlockState blockState, BlockState aboveState, VoxelShape topShape) {
        boolean tallPair;
        boolean mixed;
        boolean aboveWall;
        boolean bl = aboveWall = aboveState.getBlock() instanceof FrostyWallBlock && (Boolean)aboveState.getValue((Property)UP) != false;
        if (aboveWall) {
            return true;
        }
        WallSide north = (WallSide)blockState.getValue(NORTH_WALL);
        WallSide south = (WallSide)blockState.getValue(SOUTH_WALL);
        WallSide east = (WallSide)blockState.getValue(EAST_WALL);
        WallSide west = (WallSide)blockState.getValue(WEST_WALL);
        boolean southNone = south == WallSide.NONE;
        boolean westNone = west == WallSide.NONE;
        boolean eastNone = east == WallSide.NONE;
        boolean northNone = north == WallSide.NONE;
        boolean bl2 = mixed = northNone && southNone && westNone && eastNone || northNone != southNone || westNone != eastNone;
        if (mixed) {
            return true;
        }
        boolean bl3 = tallPair = north == WallSide.TALL && south == WallSide.TALL || east == WallSide.TALL && west == WallSide.TALL;
        if (tallPair) {
            return false;
        }
        return aboveState.is(BlockTags.WALL_POST_OVERRIDE) || FrostyWallBlock.isCovered(topShape, POST_TEST);
    }

    private BlockState updateSides(BlockState blockState, boolean north, boolean east, boolean south, boolean west, VoxelShape topShape) {
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue(NORTH_WALL, (Comparable)this.makeWallState(north, topShape, NORTH_TEST))).setValue(EAST_WALL, (Comparable)this.makeWallState(east, topShape, EAST_TEST))).setValue(SOUTH_WALL, (Comparable)this.makeWallState(south, topShape, SOUTH_TEST))).setValue(WEST_WALL, (Comparable)this.makeWallState(west, topShape, WEST_TEST));
    }

    private WallSide makeWallState(boolean connected, VoxelShape topShape, VoxelShape testShape) {
        if (!connected) {
            return WallSide.NONE;
        }
        return FrostyWallBlock.isCovered(topShape, testShape) ? WallSide.TALL : WallSide.LOW;
    }

    @NotNull
    protected FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    protected boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) == false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED, FrostyBlockInterface.FROSTY});
    }

    @NotNull
    protected BlockState rotate(BlockState blockState, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue(NORTH_WALL, (Comparable)((WallSide)blockState.getValue(SOUTH_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)blockState.getValue(WEST_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)blockState.getValue(NORTH_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)blockState.getValue(EAST_WALL)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue(NORTH_WALL, (Comparable)((WallSide)blockState.getValue(EAST_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)blockState.getValue(SOUTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)blockState.getValue(WEST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)blockState.getValue(NORTH_WALL)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue(NORTH_WALL, (Comparable)((WallSide)blockState.getValue(WEST_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)blockState.getValue(NORTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)blockState.getValue(EAST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)blockState.getValue(SOUTH_WALL)));
            default -> blockState;
        };
    }

    @NotNull
    protected BlockState mirror(BlockState blockState, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)blockState.setValue(NORTH_WALL, (Comparable)((WallSide)blockState.getValue(SOUTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)blockState.getValue(NORTH_WALL)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)blockState.setValue(EAST_WALL, (Comparable)((WallSide)blockState.getValue(WEST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)blockState.getValue(EAST_WALL)));
            default -> super.mirror(blockState, mirror);
        };
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return FrostyBlockInterface.super.handleFrostyUse(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void onProjectileHit(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        FrostyBlockInterface.super.handleFrostyProjectileHit(level, blockState, blockHitResult, projectile);
        super.onProjectileHit(level, blockState, blockHitResult, projectile);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.frosty_block.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.frosty_block.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

