/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.alpinewhispers.core.block.FrostyBlockInterface;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrostySlabBlock
extends SlabBlock
implements FrostyBlockInterface {
    public FrostySlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FrostyBlockInterface.FROSTY, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.SLAB_TYPE, BlockStateProperties.WATERLOGGED, FrostyBlockInterface.FROSTY});
    }

    protected boolean useShapeForLightOcclusion(BlockState blockState) {
        return blockState.getValue((Property)BlockStateProperties.SLAB_TYPE) != SlabType.DOUBLE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        BlockState existing = blockPlaceContext.getLevel().getBlockState(blockPos);
        if (existing.is((Block)this)) {
            return (BlockState)((BlockState)((BlockState)existing.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FrostyBlockInterface.FROSTY, (Comparable)((Boolean)existing.getValue((Property)FrostyBlockInterface.FROSTY)));
        }
        FluidState fluidState = blockPlaceContext.getLevel().getFluidState(blockPos);
        BlockState base = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue((Property)FrostyBlockInterface.FROSTY, (Comparable)Boolean.valueOf(false));
        boolean upper = blockPlaceContext.getClickLocation().y - (double)blockPos.getY() > 0.5;
        Direction face = blockPlaceContext.getClickedFace();
        if (face == Direction.DOWN) {
            return (BlockState)base.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP);
        }
        if (face == Direction.UP) {
            return base;
        }
        return upper ? (BlockState)base.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP) : base;
    }

    @NotNull
    protected BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @NotNull
    protected FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return FrostyBlockInterface.super.handleFrostyUse(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void onProjectileHit(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        FrostyBlockInterface.super.handleFrostyProjectileHit(level, blockState, blockHitResult, projectile);
        super.onProjectileHit(level, blockState, blockHitResult, projectile);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.frosty_block.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.frosty_block.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

