/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.alpinewhispers.core.block.entity.CabinetBlockEntity;
import net.satisfy.alpinewhispers.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectibleCabinetBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<GeneralUtil.LineConnectingType> TYPE = GeneralUtil.LINE_CONNECTING_TYPE;
    private final Supplier<SoundEvent> openSound;
    private final Supplier<SoundEvent> closeSound;

    public ConnectibleCabinetBlock(BlockBehaviour.Properties settings, Supplier<SoundEvent> openSound, Supplier<SoundEvent> closeSound, Supplier<Boolean> thin) {
        super(settings);
        this.openSound = openSound;
        this.closeSound = closeSound;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(TYPE, (Comparable)((Object)GeneralUtil.LineConnectingType.NONE)));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CabinetBlockEntity) {
            CabinetBlockEntity blockEntity1 = (CabinetBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blockEntity1);
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)container);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CabinetBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.has(DataComponents.CUSTOM_NAME) && (blockEntity = world.getBlockEntity(pos)) instanceof CabinetBlockEntity) {
            CabinetBlockEntity blockEntity1 = (CabinetBlockEntity)blockEntity;
            blockEntity1.setComponents(DataComponentMap.builder().set(DataComponents.CUSTOM_NAME, (Object)itemStack.getHoverName()).build());
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, TYPE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getHorizontalDirection().getOpposite();
        BlockState s = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
        Level level = ctx.getLevel();
        BlockPos p = ctx.getClickedPos();
        return (BlockState)s.setValue(TYPE, (Comparable)((Object)(switch (facing) {
            case Direction.EAST -> this.getType(s, level.getBlockState(p.south()), level.getBlockState(p.north()));
            case Direction.SOUTH -> this.getType(s, level.getBlockState(p.west()), level.getBlockState(p.east()));
            case Direction.WEST -> this.getType(s, level.getBlockState(p.north()), level.getBlockState(p.south()));
            default -> this.getType(s, level.getBlockState(p.east()), level.getBlockState(p.west()));
        })));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (level.isClientSide) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        GeneralUtil.LineConnectingType t = switch (facing) {
            case Direction.EAST -> this.getType(state, level.getBlockState(pos.south()), level.getBlockState(pos.north()));
            case Direction.SOUTH -> this.getType(state, level.getBlockState(pos.west()), level.getBlockState(pos.east()));
            case Direction.WEST -> this.getType(state, level.getBlockState(pos.north()), level.getBlockState(pos.south()));
            default -> this.getType(state, level.getBlockState(pos.east()), level.getBlockState(pos.west()));
        };
        if (state.getValue(TYPE) != t) {
            level.setBlock(pos, (BlockState)state.setValue(TYPE, (Comparable)((Object)t)), 3);
        }
    }

    private GeneralUtil.LineConnectingType getType(BlockState self, BlockState left, BlockState right) {
        boolean l = this.isConnectable(left, self);
        boolean r = this.isConnectable(right, self);
        if (l && r) {
            return GeneralUtil.LineConnectingType.MIDDLE;
        }
        if (l) {
            return GeneralUtil.LineConnectingType.LEFT;
        }
        if (r) {
            return GeneralUtil.LineConnectingType.RIGHT;
        }
        return GeneralUtil.LineConnectingType.NONE;
    }

    private boolean isConnectable(BlockState a, BlockState b) {
        return a.getBlock() == b.getBlock() && a.getValue((Property)FACING) == b.getValue((Property)FACING);
    }

    public void playSound(Level world, BlockPos pos, boolean isOpen) {
        world.playSound(null, pos, isOpen ? this.openSound.get() : this.closeSound.get(), SoundSource.BLOCKS, 1.0f, 1.1f);
    }
}

