/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.alpinewhispers.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CandleWreathBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT_FR = BooleanProperty.create((String)"lit_fr");
    public static final BooleanProperty LIT_BR = BooleanProperty.create((String)"lit_br");
    public static final BooleanProperty LIT_BL = BooleanProperty.create((String)"lit_bl");
    public static final BooleanProperty LIT_FL = BooleanProperty.create((String)"lit_fl");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final List<Vector3f> FIRE_POSITIONS = List.of(new Vector3f(11.0f, 9.0f, 3.0f), new Vector3f(11.0f, 10.0f, 11.0f), new Vector3f(3.0f, 11.0f, 11.0f), new Vector3f(3.0f, 8.0f, 3.0f));
    private static final Map<BooleanProperty, Vector3f> PARTICLE_POSITIONS = Map.of(LIT_FR, FIRE_POSITIONS.get(0), LIT_BR, FIRE_POSITIONS.get(1), LIT_BL, FIRE_POSITIONS.get(2), LIT_FL, FIRE_POSITIONS.get(3));
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.25, (double)0.1875, (double)0.3125, (double)0.4375, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.25, (double)0.6875, (double)0.8125, (double)0.5625, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.1875, (double)0.1875, (double)0.8125, (double)0.5, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.25, (double)0.6875, (double)0.3125, (double)0.625, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.375, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.125, (double)0.875, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.125, (double)0.625, (double)0.25, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.625, (double)0.625, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = state -> {
        int litCount = 0;
        if (((Boolean)state.getValue((Property)LIT_FR)).booleanValue()) {
            ++litCount;
        }
        if (((Boolean)state.getValue((Property)LIT_BR)).booleanValue()) {
            ++litCount;
        }
        if (((Boolean)state.getValue((Property)LIT_BL)).booleanValue()) {
            ++litCount;
        }
        if (((Boolean)state.getValue((Property)LIT_FL)).booleanValue()) {
            ++litCount;
        }
        return switch (litCount) {
            case 1 -> 4;
            case 2 -> 8;
            case 3 -> 12;
            case 4 -> 15;
            default -> 0;
        };
    };

    public CandleWreathBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(LIGHT_EMISSION));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT_FR, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT_BR, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT_BL, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT_FL, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT_FR, LIT_BR, LIT_BL, LIT_FL, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean waterlogged = fluidState.getType() == Fluids.WATER;
        Direction direction = context.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)LIT_FR, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT_BR, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT_BL, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT_FL, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            CandleWreathBlock.extinguish(null, state, level, pos);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Vec3 hitLocation = hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        RelativeQuadrant quadrant = this.getRelativeQuadrant(hitLocation, facing);
        LitInfo info = this.getLitInfo(quadrant);
        boolean isLighter = stack.is(Items.FLINT_AND_STEEL) || stack.is(Items.FIRE_CHARGE);
        boolean isBucket = stack.is(Items.BUCKET);
        if (!isLighter && !isBucket) {
            if (((Boolean)state.getValue((Property)info.property)).booleanValue() && level.isClientSide()) {
                Vec3 particlePos = CandleWreathBlock.rotatePosition(info.particlePosition, facing).add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                CandleWreathBlock.addParticlesAndSound(level, particlePos, level.random);
                level.playLocalSound(particlePos.x, particlePos.y, particlePos.z, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + level.random.nextFloat(), level.random.nextFloat() * 0.7f + 0.3f, false);
                return ItemInteractionResult.sidedSuccess((boolean)true);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide()) {
            if (isLighter && !((Boolean)state.getValue((Property)info.property)).booleanValue() && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                Vec3 particlePos = CandleWreathBlock.rotatePosition(info.particlePosition, facing).add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                CandleWreathBlock.addParticlesAndSound(level, particlePos, level.random);
                level.playLocalSound(particlePos.x, particlePos.y, particlePos.z, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.4f + 0.8f, false);
                return ItemInteractionResult.sidedSuccess((boolean)true);
            }
            if (isBucket && ((Boolean)state.getValue((Property)info.property)).booleanValue()) {
                Vec3 particlePos = CandleWreathBlock.rotatePosition(info.particlePosition, facing).add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                level.playLocalSound(particlePos.x, particlePos.y, particlePos.z, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                return ItemInteractionResult.sidedSuccess((boolean)true);
            }
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        BlockState newState = state;
        boolean updated = false;
        if (isLighter && !((Boolean)state.getValue((Property)info.property)).booleanValue() && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            newState = (BlockState)newState.setValue((Property)info.property, (Comparable)Boolean.valueOf(true));
            updated = true;
        } else if (isBucket && ((Boolean)state.getValue((Property)info.property)).booleanValue()) {
            newState = (BlockState)newState.setValue((Property)info.property, (Comparable)Boolean.valueOf(false));
            updated = true;
        }
        if (updated) {
            level.setBlock(pos, newState, 3);
            Vec3 particlePos = CandleWreathBlock.rotatePosition(info.particlePosition, facing).add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            CandleWreathBlock.addParticlesAndSound(level, particlePos, level.random);
            if (isLighter) {
                level.playSound(null, particlePos.x, particlePos.y, particlePos.z, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.4f + 0.8f);
            } else {
                level.playSound(null, particlePos.x, particlePos.y, particlePos.z, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)false);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        for (Map.Entry<BooleanProperty, Vector3f> entry : PARTICLE_POSITIONS.entrySet()) {
            BooleanProperty prop = entry.getKey();
            Vector3f firePos = entry.getValue();
            if (!((Boolean)state.getValue((Property)prop)).booleanValue()) continue;
            Vec3 rotatedPos = CandleWreathBlock.rotatePosition(firePos, facing).add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            CandleWreathBlock.addParticlesAndSound(level, rotatedPos, random);
        }
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!level.isClientSide && projectile.isOnFire()) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            Vec3 hitLocation = hit.getLocation().subtract((double)hit.getBlockPos().getX(), (double)hit.getBlockPos().getY(), (double)hit.getBlockPos().getZ());
            RelativeQuadrant quadrant = this.getRelativeQuadrant(hitLocation, facing);
            LitInfo info = this.getLitInfo(quadrant);
            if (info != null && !((Boolean)state.getValue((Property)info.property)).booleanValue() && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                level.setBlock(hit.getBlockPos(), (BlockState)state.setValue((Property)info.property, (Comparable)Boolean.valueOf(true)), 11);
                Vec3 particlePos = CandleWreathBlock.rotatePosition(info.particlePosition, facing).add((double)hit.getBlockPos().getX(), (double)hit.getBlockPos().getY(), (double)hit.getBlockPos().getZ());
                CandleWreathBlock.addParticlesAndSound(level, particlePos, level.random);
                level.playSound(null, particlePos.x, particlePos.y, particlePos.z, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.4f + 0.8f);
                level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, hit.getBlockPos());
            }
        }
    }

    private static void addParticlesAndSound(Level level, Vec3 vec3, RandomSource randomSource) {
        float chance = randomSource.nextFloat();
        if (chance < 0.3f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
            if (chance < 0.17f) {
                level.playLocalSound(vec3.x, vec3.y, vec3.z, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + randomSource.nextFloat(), randomSource.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
    }

    private static Vec3 rotatePosition(Vector3f position, Direction facing) {
        double x = (double)(position.x() + 1.0f) / 16.0;
        double y = (double)(position.y() + 1.0f) / 16.0;
        double z = (double)(position.z() + 1.0f) / 16.0;
        return switch (facing) {
            case Direction.EAST -> new Vec3(1.0 - z, y, x);
            case Direction.SOUTH -> new Vec3(1.0 - x, y, 1.0 - z);
            case Direction.WEST -> new Vec3(z, y, 1.0 - x);
            default -> new Vec3(x, y, z);
        };
    }

    private RelativeQuadrant getRelativeQuadrant(Vec3 hitLocation, Direction facing) {
        boolean right;
        boolean front;
        switch (facing) {
            case EAST: {
                boolean bl;
                boolean bl2 = front = hitLocation.x() > 0.5;
                if (hitLocation.z() > 0.5) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case SOUTH: {
                boolean bl;
                boolean bl3 = front = hitLocation.z() > 0.5;
                if (hitLocation.x() < 0.5) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case WEST: {
                boolean bl;
                boolean bl4 = front = hitLocation.x() < 0.5;
                if (hitLocation.z() < 0.5) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                front = hitLocation.z() < 0.5;
                boolean bl = right = hitLocation.x() > 0.5;
            }
        }
        if (front && right) {
            return RelativeQuadrant.FRONT_RIGHT;
        }
        if (front) {
            return RelativeQuadrant.FRONT_LEFT;
        }
        if (right) {
            return RelativeQuadrant.BACK_RIGHT;
        }
        return RelativeQuadrant.BACK_LEFT;
    }

    private LitInfo getLitInfo(RelativeQuadrant quadrant) {
        return switch (quadrant.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new LitInfo(LIT_FR, FIRE_POSITIONS.get(0));
            case 1 -> new LitInfo(LIT_FL, FIRE_POSITIONS.get(3));
            case 2 -> new LitInfo(LIT_BR, FIRE_POSITIONS.get(1));
            case 3 -> new LitInfo(LIT_BL, FIRE_POSITIONS.get(2));
        };
    }

    public static void extinguish(@Nullable Player player, BlockState state, LevelAccessor level, BlockPos pos) {
        BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)LIT_FR, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT_BR, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT_BL, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT_FL, (Comparable)Boolean.valueOf(false));
        level.setBlock(pos, newState, 11);
        Direction facing = (Direction)state.getValue((Property)FACING);
        for (Vector3f firePos : FIRE_POSITIONS) {
            Vec3 particlePos = CandleWreathBlock.rotatePosition(firePos, facing).add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, particlePos.x, particlePos.y, particlePos.z, 0.0, 0.1, 0.0);
        }
        level.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.canbeplaced").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }

    private static enum RelativeQuadrant {
        FRONT_RIGHT,
        FRONT_LEFT,
        BACK_RIGHT,
        BACK_LEFT;

    }

    private record LitInfo(BooleanProperty property, Vector3f particlePosition) {
    }
}

