/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.core.block;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.alpinewhispers.core.block.entity.BathtubBlockEntity;
import net.satisfy.alpinewhispers.core.registry.EntityTypeRegistry;
import net.satisfy.alpinewhispers.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BathtubBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty FULL = BooleanProperty.create((String)"full");
    private static final VoxelShape HEAD_N = BathtubBlock.makeHeadShape();
    private static final VoxelShape FOOT_N = BathtubBlock.makeFootShape();

    public BathtubBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)BedPart.HEAD)).setValue((Property)FULL, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction dir = ctx.getHorizontalDirection();
        BlockPos pos = ctx.getClickedPos();
        BlockPos other = pos.relative(dir.getOpposite());
        if (!ctx.getLevel().getBlockState(other).canBeReplaced(ctx)) {
            return null;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir)).setValue(PART, (Comparable)BedPart.HEAD);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        BlockPos footPos = pos.relative(dir.getOpposite());
        level.setBlock(footPos, (BlockState)state.setValue(PART, (Comparable)BedPart.FOOT), 3);
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && player.isCreative()) {
            BedPart part = (BedPart)state.getValue(PART);
            if (part == BedPart.HEAD) {
                BlockPos foot = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
                BlockState fs = level.getBlockState(foot);
                if (fs.is((Block)this) && fs.getValue(PART) == BedPart.FOOT) {
                    level.setBlock(foot, Blocks.AIR.defaultBlockState(), 35);
                    level.levelEvent(player, 2001, foot, Block.getId((BlockState)fs));
                }
            } else {
                BlockPos head = pos.relative((Direction)state.getValue((Property)FACING));
                BlockState hs = level.getBlockState(head);
                if (hs.is((Block)this) && hs.getValue(PART) == BedPart.HEAD) {
                    level.setBlock(head, Blocks.AIR.defaultBlockState(), 35);
                    level.levelEvent(player, 2001, head, Block.getId((BlockState)hs));
                }
            }
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Direction needed;
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction direction = needed = state.getValue(PART) == BedPart.HEAD ? facing.getOpposite() : facing;
        if (!(dir != needed || neighborState.is((Block)this) && neighborState.getValue(PART) != state.getValue(PART))) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, dir, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockState) {
        blockState.add(new Property[]{FACING, PART, FULL});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        Direction f = (Direction)state.getValue((Property)FACING);
        VoxelShape base = state.getValue(PART) == BedPart.HEAD ? HEAD_N : FOOT_N;
        return switch (f) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.UP -> base;
            case Direction.SOUTH, Direction.DOWN -> this.rotateY(base, 2);
            case Direction.EAST -> this.rotateY(base, 1);
            case Direction.WEST -> this.rotateY(base, 3);
        };
    }

    private VoxelShape rotateY(VoxelShape shape, int steps) {
        VoxelShape out = shape;
        for (int i = 0; i < steps; ++i) {
            VoxelShape tmp = Shapes.empty();
            for (AABB a : out.toAabbs()) {
                double x1 = a.minX;
                double y1 = a.minY;
                double z1 = a.minZ;
                double x2 = a.maxX;
                double y2 = a.maxY;
                double z2 = a.maxZ;
                tmp = Shapes.or((VoxelShape)tmp, (VoxelShape)Shapes.box((double)(1.0 - z2), (double)y1, (double)x1, (double)(1.0 - z1), (double)y2, (double)x2));
            }
            out = tmp.optimize();
        }
        return out;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        Direction f = (Direction)state.getValue((Property)FACING);
        boolean isHead = state.getValue(PART) == BedPart.HEAD;
        BlockPos head = isHead ? pos : pos.relative(f);
        BlockState headState = level.getBlockState(head);
        if (!headState.is((Block)this) || headState.getValue(PART) != BedPart.HEAD) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean isFullState = (Boolean)headState.getValue((Property)FULL);
        BlockEntity be = level.getBlockEntity(head);
        if (!(be instanceof BathtubBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BathtubBlockEntity tub = (BathtubBlockEntity)be;
        float ratio = Mth.clamp((float)tub.getFillRatio(0.0f), (float)0.0f, (float)1.0f);
        boolean filled = ratio >= 0.999f;
        boolean filling = tub.isFilling();
        if (hit.getBlockPos().equals((Object)head) && hit.getDirection() != Direction.DOWN && stack.isEmpty() && !filled && !filling && !isFullState) {
            tub.startFilling(900);
            level.playSound(null, head, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.CONSUME;
        }
        if (!(!stack.is(Items.WATER_BUCKET) && !stack.is(Items.GLASS_BOTTLE) || filled || filling || isFullState)) {
            tub.startFilling(900);
            level.playSound(null, head, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                if (stack.is(Items.WATER_BUCKET)) {
                    stack.shrink(1);
                    player.addItem(new ItemStack((ItemLike)Items.BUCKET));
                } else {
                    stack.shrink(1);
                    player.addItem(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                }
            }
            return ItemInteractionResult.CONSUME;
        }
        if ((stack.is(Items.BUCKET) || stack.is(Items.GLASS_BOTTLE)) && (filled || filling || isFullState)) {
            float pct;
            float f2 = pct = stack.is(Items.BUCKET) ? 0.5f : 0.25f;
            if (tub.canDrainPercent(pct) && tub.drainPercent(pct)) {
                level.playSound(null, head, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 0.7f, 1.0f);
                if (!player.isCreative()) {
                    if (stack.is(Items.BUCKET)) {
                        stack.shrink(1);
                        player.addItem(new ItemStack((ItemLike)Items.WATER_BUCKET));
                    } else {
                        stack.shrink(1);
                        PotionContents pc = new PotionContents(Potions.WATER);
                        ItemStack ps = new ItemStack((ItemLike)Items.POTION);
                        ps.set(DataComponents.POTION_CONTENTS, (Object)pc);
                        player.addItem(ps);
                    }
                }
                return ItemInteractionResult.CONSUME;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if ((filled || isFullState) && player.getVehicle() == null) {
            return GeneralUtil.onUse(level, player, hand, hit, -0.2);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource r) {
        double lx;
        if ((level.getGameTime() & 1L) != 0L) {
            return;
        }
        Direction f = (Direction)state.getValue((Property)FACING);
        boolean isHead = state.getValue(PART) == BedPart.HEAD;
        BlockPos headPos = isHead ? pos : pos.relative(f);
        BlockState headState = level.getBlockState(headPos);
        if (!headState.is((Block)this) || headState.getValue(PART) != BedPart.HEAD) {
            return;
        }
        BlockEntity be = level.getBlockEntity(headPos);
        if (!(be instanceof BathtubBlockEntity)) {
            return;
        }
        BathtubBlockEntity tub = (BathtubBlockEntity)be;
        double base = 0.475;
        double height = 0.46;
        double ratio = Mth.clamp((float)tub.getFillRatio(0.0f), (float)0.0f, (float)1.0f);
        if (!tub.isFilling() && ratio <= (double)0.02f) {
            return;
        }
        double ySurface = (double)headPos.getY() + base + height * ratio + 0.02;
        double fx = f.getStepX();
        double fz = f.getStepZ();
        double rx = -fz;
        double lz = switch (f) {
            case Direction.WEST -> {
                lx = 0.375;
                yield 0.625;
            }
            case Direction.EAST -> {
                lx = 0.675;
                yield 0.325;
            }
            case Direction.NORTH -> {
                lx = 0.325;
                yield 0.4;
            }
            default -> {
                lx = 0.675;
                yield 0.6;
            }
        };
        double cx = (double)headPos.getX() + lx;
        double cz = (double)headPos.getZ() + lz;
        if (tub.isFilling() && isHead && r.nextFloat() < 0.6f) {
            int i;
            double spx = cx + rx * 0.18;
            double spz = cz + fx * 0.18;
            double sy = (double)headPos.getY() + 1.0;
            int seg = 5;
            double dy = (sy - ySurface) / (double)seg;
            for (i = 0; i < seg; ++i) {
                double py = sy - (double)i * dy;
                double ox = (r.nextDouble() - 0.5) * 0.01;
                double oz = (r.nextDouble() - 0.5) * 0.01;
                level.addParticle((ParticleOptions)ParticleTypes.FALLING_WATER, spx + ox, py, spz + oz, 0.0, -0.18, 0.0);
            }
            for (i = 0; i < 2; ++i) {
                double ix = spx + (r.nextDouble() - 0.5) * 0.1;
                double iz = spz + (r.nextDouble() - 0.5) * 0.1;
                double vy = 0.12 + r.nextDouble() * 0.06;
                double vx = (r.nextDouble() - 0.5) * 0.03;
                double vz = (r.nextDouble() - 0.5) * 0.03;
                level.addParticle((ParticleOptions)ParticleTypes.SPLASH, ix, ySurface, iz, vx, vy, vz);
            }
        }
        if (tub.isFilling() || ratio > 0.0) {
            if (r.nextFloat() > 0.4f) {
                return;
            }
            BlockPos footPos = headPos.relative(f.getOpposite());
            for (int half = 0; half < 2; ++half) {
                BlockPos basePos = half == 0 ? headPos : footPos;
                long t = level.getGameTime();
                boolean allowPop = (t + basePos.asLong() & 0xFL) == 0L && r.nextFloat() < 0.15f;
                for (int i = 0; i < 1; ++i) {
                    double u = (r.nextDouble() - 0.5) * 0.6;
                    double v = (r.nextDouble() - 0.5) * 0.9;
                    double x = (double)basePos.getX() + 0.5 + u * rx + v * fx;
                    double z = (double)basePos.getZ() + 0.5 + u * fx + v * fz;
                    level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, x, ySurface - 0.005, z, 0.0, 0.006 + r.nextDouble() * 0.01, 0.0);
                    if (!allowPop) continue;
                    level.addParticle((ParticleOptions)ParticleTypes.SPLASH, x, ySurface + 0.01, z, 0.0, 0.03, 0.0);
                }
            }
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        Zombie z;
        BlockPos headPos = state.getValue(PART) == BedPart.HEAD ? pos : pos.relative((Direction)state.getValue((Property)FACING));
        BlockEntity be = level.getBlockEntity(headPos);
        if (!(be instanceof BathtubBlockEntity)) {
            return;
        }
        BathtubBlockEntity tub = (BathtubBlockEntity)be;
        if (!tub.isFilled()) {
            return;
        }
        if (entity instanceof EnderMan) {
            entity.hurt(level.damageSources().drown(), 4.0f);
        }
        if (entity instanceof Zombie && !(z = (Zombie)entity).isRemoved() && !level.isClientSide) {
            z.discard();
            Drowned d = (Drowned)EntityType.DROWNED.create(level);
            if (d != null) {
                d.moveTo(z.getX(), z.getY(), z.getZ(), z.getYRot(), z.getXRot());
                d.finalizeSpawn((ServerLevelAccessor)((ServerLevel)level), level.getCurrentDifficultyAt(pos), MobSpawnType.CONVERSION, null);
                level.addFreshEntity((Entity)d);
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            if (!level.isClientSide) {
                for (Holder e : le.getActiveEffectsMap().keySet()) {
                    if (((MobEffect)e.value()).getCategory() != MobEffectCategory.HARMFUL) continue;
                    le.removeEffect(e);
                }
            }
            Vec3 v = le.getDeltaMovement();
            le.setDeltaMovement(v.x * 0.6, Math.min(v.y, 0.0), v.z * 0.6);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            GeneralUtil.onStateReplaced(level, pos);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.getY(), (int)pos.getZ());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return state.getValue(PART) == BedPart.HEAD ? new BathtubBlockEntity(pos, state) : null;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (state.getValue(PART) != BedPart.HEAD) {
            return null;
        }
        if (type == EntityTypeRegistry.BATHTUB_BLOCK_ENTITY.get()) {
            return level.isClientSide ? (l, p, s, be) -> BathtubBlockEntity.clientTick((BathtubBlockEntity)be) : (l, p, s, be) -> BathtubBlockEntity.serverTick(l, p, s, (BathtubBlockEntity)be);
        }
        return null;
    }

    private static VoxelShape makeHeadShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.875, (double)0.0625, (double)0.9375, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.875, (double)0.0625, (double)0.1875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.875, (double)0.0625, (double)0.8125, (double)1.0, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.5, (double)0.1875, (double)0.8125, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)1.0, (double)0.125, (double)0.5625, (double)1.125, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.8125, (double)0.125, (double)0.5625, (double)1.0, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)1.0, (double)0.125, (double)0.375, (double)1.0625, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)1.0, (double)0.125, (double)0.75, (double)1.0625, (double)0.25), (BooleanOp)BooleanOp.OR);
        return shape.optimize();
    }

    private static VoxelShape makeFootShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.875, (double)0.0, (double)0.9375, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.875, (double)0.0, (double)0.1875, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.875, (double)0.8125, (double)0.8125, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.5, (double)0.0, (double)0.8125, (double)0.875, (double)0.8125), (BooleanOp)BooleanOp.OR);
        return shape.optimize();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.sink.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.alpinewhispers.sink.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

