/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.client.weather;

import dev.architectury.event.events.client.ClientTickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.satisfy.alpinewhispers.core.registry.SoundEventRegistry;

public class GroveSnowWeather {
    private static float avalancheIntensity = 0.0f;
    private static int avalancheSoundTicks = 0;
    private static int groveAmbientTicks = 0;

    public static void init() {
        ClientTickEvent.CLIENT_POST.register(GroveSnowWeather::tickClient);
    }

    private static void tickClient(Minecraft minecraft) {
        boolean isWeatherActive;
        if (minecraft.isPaused()) {
            return;
        }
        ClientLevel level = minecraft.level;
        LocalPlayer player = minecraft.player;
        if (level == null || player == null) {
            avalancheIntensity = 0.0f;
            avalancheSoundTicks = 0;
            groveAmbientTicks = 0;
            return;
        }
        BlockPos playerPos = player.blockPosition();
        boolean isGrove = level.getBiome(playerPos).is(Biomes.GROVE);
        boolean bl = isWeatherActive = level.isRaining() || level.isThundering();
        if (!isGrove || isWeatherActive) {
            avalancheIntensity = Mth.lerp((float)0.05f, (float)avalancheIntensity, (float)0.0f);
            avalancheSoundTicks = 0;
            groveAmbientTicks = 0;
            return;
        }
        RandomSource random = level.random;
        avalancheIntensity = Mth.clamp((float)(avalancheIntensity + 0.002f), (float)0.0f, (float)1.0f);
        if (random.nextFloat() < 0.25f) {
            GroveSnowWeather.spawnGentleSnow(level, player, random);
        }
        if (random.nextFloat() < avalancheIntensity * 0.15f) {
            GroveSnowWeather.spawnAvalancheParticles(level, player, random);
        }
        ++avalancheSoundTicks;
        if (++groveAmbientTicks >= 600) {
            GroveSnowWeather.playGroveAmbientSound(minecraft, random);
            groveAmbientTicks = 0;
        }
        if (avalancheSoundTicks >= 1800 && avalancheIntensity > 0.35f) {
            if (random.nextFloat() < 0.6f) {
                GroveSnowWeather.playAvalancheSound(minecraft, random);
            }
            avalancheSoundTicks = 0;
        }
    }

    private static void playGroveAmbientSound(Minecraft minecraft, RandomSource random) {
        float baseVolume = 0.005f;
        float volume = baseVolume * (0.6f + random.nextFloat() * 0.4f);
        float pitch = 0.9f + random.nextFloat() * 0.1f;
        minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forLocalAmbience((SoundEvent)((SoundEvent)SoundEventRegistry.GROVE_AMBIENT.get()), (float)volume, (float)pitch));
    }

    private static void playAvalancheSound(Minecraft minecraft, RandomSource random) {
        float baseVolume = 0.001f;
        float volume = baseVolume * (0.5f + avalancheIntensity * 0.5f);
        float pitch = 0.85f + random.nextFloat() * 0.1f;
        minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forLocalAmbience((SoundEvent)((SoundEvent)SoundEventRegistry.FALLING_SNOW.get()), (float)volume, (float)pitch));
    }

    private static void spawnGentleSnow(ClientLevel level, LocalPlayer player, RandomSource random) {
        int radius = 6;
        double centerX = player.getX();
        double centerZ = player.getZ();
        for (int i = 0; i < 4; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * (double)radius * 2.0;
            double offsetZ = (random.nextDouble() - 0.5) * (double)radius * 2.0;
            BlockPos samplePos = BlockPos.containing((double)(centerX + offsetX), (double)player.getY(), (double)(centerZ + offsetZ));
            BlockPos surfacePos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, samplePos);
            if (!level.canSeeSky(surfacePos)) continue;
            double particleX = (double)surfacePos.getX() + 0.5;
            double particleY = (double)surfacePos.getY() + 5.0 + random.nextDouble() * 4.0;
            double particleZ = (double)surfacePos.getZ() + 0.5;
            double velocityX = 0.0;
            double velocityY = (double)-0.02f - random.nextDouble() * (double)0.02f;
            double velocityZ = 0.0;
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
        }
    }

    private static void spawnAvalancheParticles(ClientLevel level, LocalPlayer player, RandomSource random) {
        int radius = 12;
        double centerX = player.getX();
        double centerZ = player.getZ();
        int clusterCount = 1 + (int)(avalancheIntensity * 3.0f);
        for (int clusterIndex = 0; clusterIndex < clusterCount; ++clusterIndex) {
            double offsetX = (random.nextDouble() - 0.5) * (double)radius * 2.0;
            double offsetZ = (random.nextDouble() - 0.5) * (double)radius * 2.0;
            BlockPos samplePos = BlockPos.containing((double)(centerX + offsetX), (double)player.getY(), (double)(centerZ + offsetZ));
            BlockPos surfacePos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, samplePos);
            BlockPos belowPos = surfacePos.below();
            if (!level.getBlockState(belowPos).is(Blocks.SNOW) && !level.getBlockState(belowPos).is(Blocks.SNOW_BLOCK) && !level.getBlockState(belowPos).is(Blocks.POWDER_SNOW) || (double)surfacePos.getY() < player.getY() + 2.0) continue;
            int baseY = surfacePos.getY();
            int maxDiff = 0;
            int slopeSampleRadius = 3;
            for (int dx = -slopeSampleRadius; dx <= slopeSampleRadius; ++dx) {
                for (int dz = -slopeSampleRadius; dz <= slopeSampleRadius; ++dz) {
                    BlockPos neighborSample;
                    BlockPos neighborSurface;
                    int diff;
                    if (dx == 0 && dz == 0 || (diff = Math.abs((neighborSurface = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, neighborSample = surfacePos.offset(dx, 0, dz))).getY() - baseY)) <= maxDiff) continue;
                    maxDiff = diff;
                }
            }
            if (maxDiff < 2) continue;
            double baseX = (double)surfacePos.getX() + 0.5;
            double particleBaseY = (double)surfacePos.getY() + 0.6;
            double baseZ = (double)surfacePos.getZ() + 0.5;
            double slideAngle = random.nextFloat() * ((float)Math.PI * 2);
            double slideDirectionX = (double)Mth.cos((float)((float)slideAngle)) * 0.08;
            double slideDirectionZ = (double)Mth.sin((float)((float)slideAngle)) * 0.08;
            int particlesInCluster = 8 + random.nextInt(6);
            for (int i = 0; i < particlesInCluster; ++i) {
                double step = (double)i * 0.12;
                double particleX = baseX + slideDirectionX * step;
                double particleY = particleBaseY - (double)i * 0.03;
                double particleZ = baseZ + slideDirectionZ * step;
                double velocityX = slideDirectionX * 0.7;
                double velocityY = -0.04 - random.nextDouble() * 0.03;
                double velocityZ = slideDirectionZ * 0.7;
                level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
            }
        }
    }
}

