/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.alpinewhispers.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.alpinewhispers.AlpineWhispers;
import net.satisfy.alpinewhispers.core.entity.AlpineSheepEntity;
import net.satisfy.alpinewhispers.core.entity.animation.AlpineSheepAnimation;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AlpineSheepModel<T extends AlpineSheepEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(AlpineWhispers.identifier("alpine_sheep"), "main");
    private final ModelPart alpine_sheep;
    private final ModelPart head;
    private final ModelPart bodyWool;
    private final ModelPart legWoolFrontLeft;
    private final ModelPart legWoolFrontRight;
    private final ModelPart legWoolBackLeft;
    private final ModelPart legWoolBackRight;
    private boolean baby;

    public AlpineSheepModel(ModelPart root) {
        this.alpine_sheep = root.getChild("alpine_sheep");
        this.head = this.alpine_sheep.getChild("head");
        ModelPart body = this.alpine_sheep.getChild("body");
        this.bodyWool = body.getChild("bodywool");
        this.legWoolFrontLeft = this.alpine_sheep.getChild("leg0").getChild("legwool");
        this.legWoolFrontRight = this.alpine_sheep.getChild("leg1").getChild("legwool2");
        this.legWoolBackLeft = this.alpine_sheep.getChild("leg2").getChild("legwool3");
        this.legWoolBackRight = this.alpine_sheep.getChild("leg3").getChild("legwool4");
    }

    public void setupAnim(AlpineSheepEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.baby = entity.isBaby();
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.updateWoolVisibility(entity);
        this.animateWalk(AlpineSheepAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(entity.idleAnimationState, AlpineSheepAnimation.idle, ageInTicks, 1.0f);
        this.animate(entity.eatAnimationState, AlpineSheepAnimation.eat, ageInTicks, 1.0f);
        this.animate(entity.shakeAnimationState, AlpineSheepAnimation.shake, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch) {
        netHeadYaw = Mth.clamp((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    private void updateWoolVisibility(AlpineSheepEntity entity) {
        boolean woolVisible;
        this.bodyWool.visible = woolVisible = !entity.isSheared();
        this.legWoolFrontLeft.visible = woolVisible;
        this.legWoolFrontRight.visible = woolVisible;
        this.legWoolBackLeft.visible = woolVisible;
        this.legWoolBackRight.visible = woolVisible;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, int alpha) {
        if (this.baby) {
            boolean previousHeadVisible = this.head.visible;
            this.head.visible = false;
            this.alpine_sheep.render(poseStack, vertexConsumer, light, overlay, alpha);
            this.head.visible = previousHeadVisible;
            poseStack.pushPose();
            this.alpine_sheep.translateAndRotate(poseStack);
            poseStack.translate(0.0f, 0.9f, 0.5f);
            poseStack.scale(1.8f, 1.8f, 1.8f);
            this.head.render(poseStack, vertexConsumer, light, overlay, alpha);
            poseStack.popPose();
            return;
        }
        this.alpine_sheep.render(poseStack, vertexConsumer, light, overlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.alpine_sheep;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition alpineSheep = partDefinition.addOrReplaceChild("alpine_sheep", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = alpineSheep.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -2.0f, 8.0f, 16.0f, 6.0f, new CubeDeformation(1.4f)), PartPose.offsetAndRotation((float)0.0f, (float)-14.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition bodywool = body.addOrReplaceChild("bodywool", CubeListBuilder.create().texOffs(0, 22).addBox(-4.0f, -8.0f, -2.0f, 8.0f, 16.0f, 6.0f, new CubeDeformation(1.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(28, 21).addBox(-1.0f, 0.0f, -5.75f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.0f, (float)4.75f));
        PartDefinition head = alpineSheep.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 0).addBox(-4.0f, -5.0f, -5.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-18.0f, (float)-9.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(28, 13).addBox(-5.0f, -1.0f, -3.0f, 8.0f, 2.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offset((float)1.0f, (float)-5.0f, (float)-2.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(28, 29).addBox(-2.0f, -1.75f, -1.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.75f, (float)-6.0f));
        PartDefinition ear1 = head.addOrReplaceChild("ear1", CubeListBuilder.create(), PartPose.offset((float)3.75f, (float)-2.25f, (float)-1.5f));
        PartDefinition ear_0_r1 = ear1.addOrReplaceChild("ear_0_r1", CubeListBuilder.create().texOffs(22, 22).addBox(-0.567f, -1.0996f, -0.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition ear2 = head.addOrReplaceChild("ear2", CubeListBuilder.create(), PartPose.offset((float)-3.75f, (float)-3.0f, (float)-1.5f));
        PartDefinition ear_1_r1 = ear2.addOrReplaceChild("ear_1_r1", CubeListBuilder.create().texOffs(22, 22).mirror().addBox(-3.8796f, -0.5853f, -0.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition leg0 = alpineSheep.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(16, 44).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-10.0f, (float)7.0f));
        PartDefinition legwool = leg0.addOrReplaceChild("legwool", CubeListBuilder.create().texOffs(0, 44).addBox(-2.0f, -0.5f, -2.25f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.25f));
        PartDefinition leg1 = alpineSheep.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(16, 44).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-10.0f, (float)7.0f));
        PartDefinition legwool2 = leg1.addOrReplaceChild("legwool2", CubeListBuilder.create().texOffs(0, 44).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg2 = alpineSheep.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(16, 44).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-10.0f, (float)-6.0f));
        PartDefinition legwool3 = leg2.addOrReplaceChild("legwool3", CubeListBuilder.create().texOffs(0, 44).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg3 = alpineSheep.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(16, 44).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-10.0f, (float)-6.0f));
        PartDefinition legwool4 = leg3.addOrReplaceChild("legwool4", CubeListBuilder.create().texOffs(0, 44).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }
}

