/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.common.IMenuSerializer;
import moe.plushie.armourers_workshop.api.common.IPlayerDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractEntityDataSerializer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.EntityCollisionShape;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.core.utils.StreamUtils;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.Strings;

public class DataSerializers {
    public static final IDataCodec<IResourceLocation> RESOURCE_LOCATION = IDataCodec.STRING.xmap(OpenResourceLocation::parse, (Function<IResourceLocation, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lmoe/plushie/armourers_workshop/api/core/IResourceLocation;)Ljava/lang/String;)());
    public static final IDataCodec<OpenRectangle3f> BOUNDING_BOX = IDataCodec.FLOAT.listOf().xmap(OpenRectangle3f::new, OpenRectangle3f::toList);
    public static final IDataCodec<SkinPaintData> COMPRESSED_PAINT_DATA = IDataCodec.BYTE_BUFFER.xmap(DataSerializers::decompressPaintData, DataSerializers::compressPaintData);
    public static final IDataCodec<EntityTextureDescriptor.Model> ENTITY_TEXTURE_MODEL = IDataCodec.INT.xmap(DataSerializers::parseTextureModel, Enum::ordinal);
    public static final IEntitySerializer<CompoundTag> COMPOUND_TAG = DataSerializers.of(EntityDataSerializers.COMPOUND_TAG);
    public static final IEntitySerializer<Integer> INT = DataSerializers.of(EntityDataSerializers.INT);
    public static final IEntitySerializer<String> STRING = DataSerializers.of(EntityDataSerializers.STRING);
    public static final IEntitySerializer<Boolean> BOOLEAN = DataSerializers.of(EntityDataSerializers.BOOLEAN);
    public static final IEntitySerializer<Float> FLOAT = DataSerializers.of(EntityDataSerializers.FLOAT);
    public static final IEntitySerializer<Vec3> VECTOR_3D = new IEntitySerializer<Vec3>(){

        @Override
        public void write(IFriendlyByteBuf buffer, Vec3 pos) {
            buffer.writeDouble(pos.x());
            buffer.writeDouble(pos.y());
            buffer.writeDouble(pos.z());
        }

        @Override
        public Vec3 read(IFriendlyByteBuf buffer) {
            return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    };
    public static final IEntitySerializer<OpenVector3f> VECTOR_3F = new IEntitySerializer<OpenVector3f>(){

        @Override
        public void write(IFriendlyByteBuf buffer, OpenVector3f pos) {
            buffer.writeFloat(pos.x());
            buffer.writeFloat(pos.y());
            buffer.writeFloat(pos.z());
        }

        @Override
        public OpenVector3f read(IFriendlyByteBuf buffer) {
            return new OpenVector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final IEntitySerializer<SkinPaintColor> PAINT_COLOR = new IEntitySerializer<SkinPaintColor>(){

        @Override
        public void write(IFriendlyByteBuf buffer, SkinPaintColor color) {
            buffer.writeInt(color.rawValue());
        }

        @Override
        public SkinPaintColor read(IFriendlyByteBuf buffer) {
            return SkinPaintColor.of(buffer.readInt());
        }
    };
    public static final IEntitySerializer<EntityTextureDescriptor> PLAYER_TEXTURE = new IEntitySerializer<EntityTextureDescriptor>(){

        @Override
        public void write(IFriendlyByteBuf buffer, EntityTextureDescriptor descriptor) {
            buffer.writeNbtWithCodec(EntityTextureDescriptor.CODEC, descriptor);
        }

        @Override
        public EntityTextureDescriptor read(IFriendlyByteBuf buffer) {
            return buffer.readNbtWithCodec(EntityTextureDescriptor.CODEC);
        }
    };
    public static final IEntitySerializer<EntityTextureDescriptor.Model> PLAYER_TEXTURE_MODEL = new IEntitySerializer<EntityTextureDescriptor.Model>(){

        @Override
        public void write(IFriendlyByteBuf buffer, EntityTextureDescriptor.Model descriptor) {
            buffer.writeInt(descriptor.ordinal());
        }

        @Override
        public EntityTextureDescriptor.Model read(IFriendlyByteBuf buffer) {
            return EntityTextureDescriptor.Model.values()[buffer.readInt()];
        }
    };
    public static final IEntitySerializer<EntityCollisionShape> COLLISION_SHAPE_OPT = new IEntitySerializer<EntityCollisionShape>(){

        @Override
        public EntityCollisionShape read(IFriendlyByteBuf buffer) {
            int size = buffer.readVarInt();
            if (size == 0) {
                return null;
            }
            ArrayList<Float> values = new ArrayList<Float>();
            for (int i = 0; i < size; ++i) {
                values.add(Float.valueOf(buffer.readFloat()));
            }
            return new EntityCollisionShape(values);
        }

        @Override
        public void write(IFriendlyByteBuf buffer, EntityCollisionShape shape) {
            List<Float> values = Objects.flatMap(shape, EntityCollisionShape::toList);
            if (values == null) {
                values = Collections.emptyList();
            }
            buffer.writeVarInt(values.size());
            for (Float value : values) {
                buffer.writeFloat(value.floatValue());
            }
        }
    };
    public static final IEntitySerializer<Exception> EXCEPTION = new IEntitySerializer<Exception>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(IFriendlyByteBuf buffer, Exception exception) {
            OutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                boolean compress = ModConfig.Common.enableServerCompressesSkins;
                buffer.writeBoolean(compress);
                outputStream = this.createOutputStream(buffer, compress);
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(exception);
            }
            catch (Exception exception1) {
                try {
                    exception1.printStackTrace();
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(objectOutputStream, outputStream);
                    throw throwable;
                }
                StreamUtils.closeQuietly(objectOutputStream, outputStream);
            }
            StreamUtils.closeQuietly(objectOutputStream, outputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception read(IFriendlyByteBuf buffer) {
            Exception exception;
            InputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                boolean compress = buffer.readBoolean();
                inputStream = this.createInputStream(buffer, compress);
                objectInputStream = new ObjectInputStream(inputStream);
                exception = (Exception)objectInputStream.readObject();
            }
            catch (Exception exception2) {
                Exception exception3;
                try {
                    exception3 = exception2;
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(objectInputStream, inputStream);
                    throw throwable;
                }
                StreamUtils.closeQuietly(objectInputStream, inputStream);
                return exception3;
            }
            StreamUtils.closeQuietly(objectInputStream, inputStream);
            return exception;
        }

        public Exception copy(Exception value) {
            return value;
        }

        private InputStream createInputStream(IFriendlyByteBuf buffer, boolean compress) throws Exception {
            ByteBufInputStream inputStream = new ByteBufInputStream(buffer.asByteBuf());
            if (compress) {
                return new GZIPInputStream((InputStream)inputStream);
            }
            return inputStream;
        }

        private OutputStream createOutputStream(IFriendlyByteBuf buffer, boolean compress) throws Exception {
            ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer.asByteBuf());
            if (compress) {
                return new GZIPOutputStream((OutputStream)outputStream);
            }
            return outputStream;
        }
    };
    public static final IMenuSerializer<SkinWardrobe> ENTITY_WARDROBE = new IMenuSerializer<SkinWardrobe>(){

        @Override
        public void write(IFriendlyByteBuf buffer, Player player, SkinWardrobe wardrobe) {
            buffer.writeInt(wardrobe.id());
            buffer.writeResourceLocation(wardrobe.profile().registryName());
        }

        @Override
        public SkinWardrobe read(IFriendlyByteBuf buffer, Player player) {
            if (player == null || PropertyProvider.getLevel((Entity)player) == null) {
                return null;
            }
            int entityId = buffer.readInt();
            Entity entity = PropertyProvider.getLevel((Entity)player).getEntity(entityId);
            if (entity == null) {
                for (Player player1 : PropertyProvider.getLevel((Entity)player).players()) {
                    if (player1.getId() != entityId) continue;
                    entity = player1;
                    break;
                }
            }
            SkinWardrobe wardrobe = SkinWardrobe.of(entity);
            EntityProfile serverProfile = ModEntityProfiles.getProfile(buffer.readResourceLocation());
            if (wardrobe != null && serverProfile != null) {
                wardrobe.setProfile(serverProfile);
            }
            return wardrobe;
        }
    };
    public static final IMenuSerializer<IGlobalPos> GLOBAL_POS = new IMenuSerializer<IGlobalPos>(){

        @Override
        public void write(IFriendlyByteBuf buffer, Player player, IGlobalPos callable) {
            Optional<BlockPos> pos1 = callable.evaluate((world, pos) -> pos);
            buffer.writeBlockPos(pos1.orElse(BlockPos.ZERO));
        }

        @Override
        public IGlobalPos read(IFriendlyByteBuf buffer, Player player) {
            if (player == null || PropertyProvider.getLevel((Entity)player) == null) {
                return null;
            }
            BlockPos blockPos = buffer.readBlockPos();
            return IGlobalPos.create(PropertyProvider.getLevel((Entity)player), blockPos);
        }
    };
    public static final IPlayerDataSerializer<SkinType> SKIN_TYPE = new IPlayerDataSerializer<SkinType>(){

        @Override
        public void write(IFriendlyByteBuf buffer, Player player, SkinType value) {
            buffer.writeUtf(value.registryName().toString());
        }

        @Override
        public SkinType read(IFriendlyByteBuf buffer, Player player) {
            return SkinTypes.byName(buffer.readUtf());
        }
    };
    public static final IPlayerDataSerializer<SkinProperties> SKIN_PROPERTIES = new IPlayerDataSerializer<SkinProperties>(){

        @Override
        public void write(IFriendlyByteBuf buffer, Player player, SkinProperties value) {
            CompoundTag nbt = new CompoundTag();
            value.writeToNBT(nbt);
            buffer.writeNbt(nbt);
        }

        @Override
        public SkinProperties read(IFriendlyByteBuf buffer, Player player) {
            SkinProperties properties = new SkinProperties();
            CompoundTag nbt = buffer.readNbt();
            if (nbt != null) {
                properties.readFromNBT(nbt);
            }
            return properties;
        }
    };
    private static final Random RANDOM = new Random();

    public static <T> IEntitySerializer<T> of(EntityDataSerializer<T> serializer) {
        return AbstractEntityDataSerializer.wrap(serializer);
    }

    public static GameProfile readGameProfile(CompoundTag tag) {
        try {
            String name = OptionalAPI.getOptionalString(tag, "Name").orElse(null);
            UUID id = OptionalAPI.getOptionalUUID(tag, "Id").orElse(null);
            return new GameProfile(id, name);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static CompoundTag writeGameProfile(CompoundTag tag, GameProfile value) {
        if (value == null) {
            return tag;
        }
        if (Strings.isNotBlank((String)value.getName())) {
            tag.putString("Name", value.getName());
        }
        if (value.getId() != null) {
            tag.putUUID("Id", value.getId());
        }
        return tag;
    }

    public static void dropContents(Level level, BlockPos blockPos, Container container) {
        DataSerializers.dropContents(level, blockPos.getX(), blockPos.getY(), blockPos.getZ(), container);
    }

    public static void dropContents(Level level, Entity entity, Container container) {
        DataSerializers.dropContents(level, entity.getX(), entity.getY(), entity.getZ(), container);
    }

    private static void dropContents(Level level, double x, double y, double z, Container container) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            DataSerializers.dropItemStack(level, x, y, z, container.getItem(i));
        }
    }

    public static void dropContents(Level level, BlockPos blockPos, List<ItemStack> itemStacks) {
        itemStacks.forEach(itemStack -> DataSerializers.dropItemStack(level, blockPos, itemStack));
    }

    public static void dropItemStack(Level level, BlockPos blockPos, ItemStack itemStack) {
        DataSerializers.dropItemStack(level, blockPos.getX(), blockPos.getY(), blockPos.getZ(), itemStack);
    }

    public static void dropItemStack(Level level, double x, double y, double z, ItemStack itemStack) {
        double d0 = EntityType.ITEM.getWidth();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + RANDOM.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + RANDOM.nextDouble() * d1;
        double d5 = Math.floor(z) + RANDOM.nextDouble() * d1 + d2;
        while (!itemStack.isEmpty()) {
            ItemEntity itementity = new ItemEntity(level, d3, d4, d5, itemStack.split(RANDOM.nextInt(21) + 10));
            float f = 0.05f;
            itementity.setDeltaMovement(RANDOM.nextGaussian() * (double)0.05f, RANDOM.nextGaussian() * (double)0.05f + (double)0.2f, RANDOM.nextGaussian() * (double)0.05f);
            level.addFreshEntity((Entity)itementity);
        }
    }

    public static SkinPaintData decompressPaintData(ByteBuffer buffer) {
        SkinPaintData skinPaintData;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer.array());
        DataInputStream dataStream = new DataInputStream(new GZIPInputStream(inputStream));
        try {
            SkinPaintData paintData = SkinPaintData.v2(false);
            int length = dataStream.readInt();
            int[] colors = paintData.bytes();
            for (int i = 0; i < length; ++i) {
                if (i >= colors.length) continue;
                colors[i] = dataStream.readInt();
            }
            skinPaintData = paintData;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                return null;
            }
        }
        dataStream.close();
        return skinPaintData;
    }

    public static ByteBuffer compressPaintData(SkinPaintData paintData) {
        ByteBuffer throwable2;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(new GZIPOutputStream(outputStream));
        try {
            int[] colors = paintData.bytes();
            dataStream.writeInt(colors.length);
            for (int color : colors) {
                dataStream.writeInt(color);
            }
            dataStream.close();
            throwable2 = ByteBuffer.wrap(outputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataStream.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        dataStream.close();
        return throwable2;
    }

    public static EntityTextureDescriptor.Model parseTextureModel(int index) {
        EntityTextureDescriptor.Model[] values = EntityTextureDescriptor.Model.values();
        if (index < values.length) {
            return values[index];
        }
        return EntityTextureDescriptor.Model.STEVE;
    }
}

