/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.network;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.DataEncryptMethod;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileOptions;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinSerializer;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.StreamUtils;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.library.data.SkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.library.menu.SkinLibraryMenu;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SaveSkinPacket
extends CustomPacket {
    private final Target source;
    private final Target destination;
    private Mode mode = Mode.NONE;
    private Payload payload;

    public SaveSkinPacket(String source, SkinFileOptions sourceOptions, String destination, SkinFileOptions destinationOptions) {
        boolean shouldUpload;
        this.source = new Target(source, sourceOptions);
        this.destination = new Target(destination, destinationOptions);
        boolean bl = shouldUpload = this.source.isLocal() && !this.destination.isLocal();
        if (shouldUpload) {
            this.mode = Mode.UPLOAD;
            if (SkinLibraryManager.getClient().shouldUploadFile(null)) {
                this.payload = Payload.loadWithOptions(source, sourceOptions);
            }
        }
    }

    public SaveSkinPacket(IFriendlyByteBuf buffer) {
        this.source = Target.readFromStream(buffer);
        this.destination = Target.readFromStream(buffer);
        this.mode = buffer.readEnum(Mode.class);
        switch (this.mode.ordinal()) {
            case 1: {
                boolean shouldUpload;
                boolean bl = shouldUpload = this.source.isLocal() && !this.destination.isLocal();
                if (!shouldUpload || !SkinLibraryManager.getServer().shouldUploadFile(null)) break;
                this.payload = Payload.readFromStream(buffer, this.resolveLoadOptions(this.source.options));
                break;
            }
            case 2: {
                boolean shouldDownload;
                boolean bl = shouldDownload = !this.source.isLocal() && this.destination.isLocal();
                if (!shouldDownload) break;
                this.payload = Payload.readFromStream(buffer, null);
                break;
            }
        }
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        this.source.writeToStream(buffer);
        this.destination.writeToStream(buffer);
        if (this.payload != null) {
            buffer.writeEnum(this.mode);
            this.payload.writeToStream(buffer);
        } else {
            buffer.writeEnum(Mode.NONE);
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        if (!this.destination.isLocal()) {
            return;
        }
        Skin skin = this.getSkin();
        if (skin == null) {
            this.abort(player, "load", "missing from skin loader");
            return;
        }
        SkinLibrary library = SkinLibraryManager.getClient().localLibrary();
        library.save(this.destination.path, skin, this.destination.options);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu;
        if (!(this.source.isAuthorized((Player)player) && this.destination.isAuthorized((Player)player) && (abstractContainerMenu = player.containerMenu) instanceof SkinLibraryMenu)) {
            this.abort((Player)player, "unauthorized", "user status is incorrect or the path is invalid");
            return;
        }
        SkinLibraryMenu container = (SkinLibraryMenu)abstractContainerMenu;
        SkinLibraryManager.Server server = SkinLibraryManager.getServer();
        if (this.source.isLocal() && !server.shouldUploadFile((Player)player)) {
            this.abort((Player)player, "upload", "uploading prohibited in the config file");
            return;
        }
        if (this.destination.isDatabase()) {
            if (!ModPermissions.SKIN_LIBRARY_SKIN_LOAD.accept((Player)player)) {
                this.abort((Player)player, "load", "load prohibited in the config file");
                return;
            }
            Skin skin = this.getSkin();
            if (skin == null) {
                this.abort((Player)player, "load", "missing from skin loader");
                return;
            }
            if (container.shouldLoadStack()) {
                this.accept((Player)player, "load");
                String identifier = SkinLoader.getInstance().saveSkin(this.source.identifier, skin);
                container.crafting(new SkinDescriptor(identifier, skin.type()));
            }
            return;
        }
        if (this.destination.isServer()) {
            if (!ModPermissions.SKIN_LIBRARY_SKIN_SAVE.accept((Player)player)) {
                this.abort((Player)player, "save", "save prohibited in the config file");
                return;
            }
            Skin skin = this.getSkin();
            if (skin == null) {
                this.abort((Player)player, "save", "missing from skin loader");
                return;
            }
            if (!skin.settings().isSavable()) {
                this.abort((Player)player, "save", "save prohibited from the skin author");
                return;
            }
            if (container.shouldSaveStack()) {
                this.accept((Player)player, "save");
                SkinLoader.getInstance().removeSkin(this.destination.identifier);
                server.library().save(this.destination.path, skin, this.destination.options);
                container.crafting(null);
            }
            return;
        }
        if (this.destination.isLocal()) {
            if (!this.source.isLocal() && !server.shouldDownloadFile((Player)player)) {
                this.abort((Player)player, "download", "download prohibited in the config file");
                return;
            }
            if (!this.source.isLocal()) {
                this.mode = Mode.DOWNLOAD;
                Skin skin = this.getSkin();
                if (skin == null || !skin.settings().isSavable()) {
                    this.abort((Player)player, "download", "download prohibited from the skin author");
                    return;
                }
            }
            if (container.shouldSaveStack()) {
                this.accept((Player)player, "download");
                NetworkManager.sendTo(this, player);
                container.crafting(null);
            }
            return;
        }
        this.abort((Player)player, "unknown", "dangerous operation");
    }

    public boolean isReady(Player player) {
        SkinLibraryManager.Client libraryManager = SkinLibraryManager.getClient();
        if (this.source.isLocal() && !this.destination.isLocal() && !libraryManager.shouldUploadFile(player)) {
            return false;
        }
        if (!this.source.isLocal() && this.destination.isLocal() && !libraryManager.shouldDownloadFile(player)) {
            return false;
        }
        return this.mode == Mode.NONE || this.payload != null;
    }

    private void accept(Player player, String op) {
        ModLog.info("accept {} request of the '{}', from: '{}', to: '{}'", op, player.getScoreboardName(), this.source, this.destination);
    }

    private void abort(Player player, String op, String reason) {
        ModLog.info("abort {} request of the '{}', reason: '{}', from: '{}', to: '{}'", op, player.getScoreboardName(), reason, this.source, this.destination);
    }

    private Skin getSkin() {
        if (this.payload != null) {
            return this.payload.get();
        }
        this.payload = Payload.create(this.source.identifier, this.source.options);
        if (this.payload != null) {
            return this.payload.get();
        }
        return null;
    }

    private SkinFileOptions resolveLoadOptions(SkinFileOptions options) {
        SkinLibraryManager.Server server;
        if (options != null && (server = SkinLibraryManager.getServer()).isRunning() && Objects.equals(options.securityData(), server.publicKey())) {
            SkinFileOptions fixedOptions = new SkinFileOptions();
            fixedOptions.merge(options);
            fixedOptions.setSecurityKey(DataEncryptMethod.AUTH.key(server.privateKey()));
            fixedOptions.setSecurityData(server.publicKey());
            return fixedOptions;
        }
        return options;
    }

    public static enum Mode {
        NONE,
        UPLOAD,
        DOWNLOAD;

    }

    private static class Target {
        protected final String identifier;
        protected final SkinFileOptions options;
        protected final String path;

        public Target(String identifier, SkinFileOptions options) {
            this.identifier = identifier;
            this.options = options;
            this.path = DataDomain.getPath(identifier);
        }

        public static Target readFromStream(IFriendlyByteBuf buffer) {
            Object identifier = buffer.readUtf();
            int index = ((String)identifier).indexOf(58);
            if (index < 0) {
                throw new RuntimeException("illegal identifier!!!");
            }
            String path = FileUtils.normalize(((String)identifier).substring(index + 1), true);
            if (path != null) {
                identifier = String.valueOf(((String)identifier).subSequence(0, index + 1)) + path;
            }
            SkinFileOptions options = null;
            CompoundTag optionsTag = buffer.readNbt();
            if (optionsTag != null) {
                options = new SkinFileOptions(optionsTag);
            }
            return new Target((String)identifier, options);
        }

        public void writeToStream(IFriendlyByteBuf buffer) {
            buffer.writeUtf(this.identifier);
            if (this.options != null) {
                buffer.writeNbt(this.options.serializeNBT());
            } else {
                buffer.writeNbt(null);
            }
        }

        public boolean isLocal() {
            return DataDomain.isLocal(this.identifier);
        }

        public boolean isServer() {
            return DataDomain.isServer(this.identifier);
        }

        public boolean isDatabase() {
            return DataDomain.isDatabase(this.identifier);
        }

        public boolean isUnknown() {
            return this.identifier.isEmpty();
        }

        public boolean isAuthorized(Player player) {
            if (this.isServer()) {
                if (this.path.startsWith("/private/" + player.getStringUUID())) {
                    return true;
                }
                if (this.path.startsWith("/private")) {
                    return false;
                }
                return this.path.startsWith("/");
            }
            return !this.isUnknown();
        }

        public String toString() {
            return this.identifier;
        }
    }

    private static class Payload {
        private Skin skin;

        public Payload(Skin skin) {
            this.skin = skin;
        }

        public static Payload create(String identifier, SkinFileOptions options) {
            try {
                InputStream inputStream = SkinLoader.getInstance().loadSkinData(identifier);
                return new Payload(SkinSerializer.readFromStream(options, inputStream));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static Payload loadWithOptions(String identifier, SkinFileOptions options) {
            if (options != null && options.securityData() != null && Objects.equals(options.securityKey(), "")) {
                return DirectyPayload.create(identifier, options);
            }
            return Payload.create(identifier, options);
        }

        public static Payload readFromStream(IFriendlyByteBuf buffer, SkinFileOptions options) {
            Payload payload;
            GZIPInputStream inputStream = new GZIPInputStream((InputStream)new ByteBufInputStream(buffer.asByteBuf()));
            try {
                payload = new Payload(SkinSerializer.readFromStream(options, inputStream));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            inputStream.close();
            return payload;
        }

        public void writeToStream(IFriendlyByteBuf buffer) {
            try (GZIPOutputStream outputStream = new GZIPOutputStream((OutputStream)new ByteBufOutputStream(buffer.asByteBuf()));){
                SkinSerializer.writeToStream(this.skin, null, outputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Skin get() {
            return this.skin;
        }
    }

    private static class DirectyPayload
    extends Payload {
        private final byte[] bytes;

        public DirectyPayload(byte[] bytes) {
            super(null);
            this.bytes = bytes;
        }

        public static DirectyPayload create(String identifier, SkinFileOptions options) {
            try {
                InputStream inputStream = SkinLoader.getInstance().loadSkinData(identifier);
                byte[] bytes = StreamUtils.readStreamToByteArray(inputStream);
                return new DirectyPayload(bytes);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void writeToStream(IFriendlyByteBuf buffer) {
            try (GZIPOutputStream outputStream = new GZIPOutputStream((OutputStream)new ByteBufOutputStream(buffer.asByteBuf()));){
                outputStream.write(this.bytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

