/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.menu;

import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.library.blockentity.GlobalSkinLibraryBlockEntity;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class GlobalSkinLibraryMenu
extends AbstractBlockEntityMenu<GlobalSkinLibraryBlockEntity> {
    private final Container inventory = new SimpleContainer(2);
    private final Inventory playerInventory;
    public int inventoryWidth = 162;
    public int inventoryHeight = 76;
    private boolean isVisible = false;

    public GlobalSkinLibraryMenu(MenuType<?> menuType, Block block, int containerId, Inventory playerInventory, IGlobalPos access) {
        super((MenuType)menuType, block, containerId, access);
        this.playerInventory = playerInventory;
        this.reload(0, 0, 240, 240);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public ItemStack inputStack() {
        return this.inventory.getItem(0);
    }

    public void reload(int x, int y, int width, int height) {
        this.slots.clear();
        int inventoryX = x + 5;
        int inventoryY = y + height;
        this.addPlayerSlots((Container)this.playerInventory, x + width - this.inventoryWidth - 4, y + height - this.inventoryHeight - 5, this.visibleSlotBuilder(() -> this.isVisible));
        this.addInputSlot(this.inventory, 0, inventoryX + 1, inventoryY - 27);
        this.addOutputSlot(this.inventory, 1, inventoryX + 129, inventoryY - 27);
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, this.inventory);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        return this.quickMoveStack(player, index, this.slots.size() - 1);
    }

    public void crafting() {
        this.clearContainer(this.playerInventory.player, this.inventory);
    }

    protected void addInputSlot(Container inventory, int slot, int x, int y) {
        this.addSlot(new Slot(inventory, slot, x, y){

            public boolean mayPlace(ItemStack itemStack) {
                return !SkinDescriptor.of(itemStack).isEmpty();
            }

            public boolean isActive() {
                return GlobalSkinLibraryMenu.this.isVisible;
            }
        });
    }

    protected void addOutputSlot(Container inventory, int slot, int x, int y) {
        this.addSlot(new Slot(inventory, slot, x, y){

            public boolean mayPlace(ItemStack itemStack) {
                return false;
            }

            public boolean isActive() {
                return GlobalSkinLibraryMenu.this.isVisible;
            }
        });
    }
}

