/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.render;

import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.utils.OpenModelPart;
import moe.plushie.armourers_workshop.core.utils.OpenModelPartBuilder;
import moe.plushie.armourers_workshop.library.block.GlobalSkinLibraryBlock;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlobalSkinLibraryBlockRenderer<T extends BlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private final OpenModelPart model = OpenModelPartBuilder.of(64, 32).cube(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f).build();

    public GlobalSkinLibraryBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.75f, 0.5f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        float f = 0.0625f;
        float xPos = 2.5f;
        float zPos = 4.6f;
        float yPos = 4.0f;
        BlockState state = entity.getBlockState();
        Direction direction = ((Direction)state.getValue((Property)GlobalSkinLibraryBlock.FACING)).getOpposite();
        poseStack.translate((xPos * (float)(-direction.getStepZ()) + zPos * (float)direction.getStepX()) * f, yPos * f, (xPos * (float)(-direction.getStepX()) + zPos * (float)(-direction.getStepZ())) * f);
        poseStack.scale(0.2f, 0.2f, 0.2f);
        if (entity.getLevel() != null) {
            float angle = (float)(entity.getLevel().getGameTime() % 360L) + partialTicks;
            poseStack.rotate(new OpenQuaternionf(angle * 4.0f, angle, angle * 2.0f, true));
        }
        IVertexConsumer builder = bufferSource.getBuffer(SkinRenderType.BLOCK_EARTH);
        this.model.render(poseStack, builder, 0xF000F0, overlay, Integer.MAX_VALUE);
        poseStack.popPose();
    }
}

