/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.key.IKeyBinding;
import moe.plushie.armourers_workshop.api.client.key.IKeyModifier;
import moe.plushie.armourers_workshop.api.event.EventBus;
import moe.plushie.armourers_workshop.api.registry.IKeyBindingBuilder;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeKeyMapping;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.event.client.RenderFrameEvent;
import moe.plushie.armourers_workshop.utils.OpenKeyModifier;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;

public class KeyBindingBuilderImpl<T extends IKeyBinding>
implements IKeyBindingBuilder<T> {
    private static final ArrayList<Pair<KeyMapping, Supplier<Runnable>>> INPUTS = KeyBindingBuilderImpl.createAndAttach();
    private final String key;
    private IKeyModifier modifier = OpenKeyModifier.NONE;
    private String category = "";
    private Supplier<Runnable> handler;

    public KeyBindingBuilderImpl(String key) {
        this.key = key;
    }

    @Override
    public IKeyBindingBuilder<T> modifier(IKeyModifier modifier) {
        this.modifier = modifier;
        return this;
    }

    @Override
    public IKeyBindingBuilder<T> category(String category) {
        this.category = category;
        return this;
    }

    @Override
    public IKeyBindingBuilder<T> bind(Supplier<Runnable> handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public T build(String name) {
        String nameKey = "keys.armourers_workshop." + name;
        String categoryKey = "keys.armourers_workshop." + this.category;
        InputConstants.Key input = InputConstants.getKey((String)this.key);
        final OnceKeyBinding binding = KeyBindingBuilderImpl.createKeyBinding(nameKey, this.modifier, input, categoryKey);
        if (this.handler != null) {
            INPUTS.add((Pair<KeyMapping, Supplier<Runnable>>)Pair.of((Object)((Object)binding), this.handler));
        }
        AbstractForgeKeyMapping.register(name, binding);
        IKeyBinding binding1 = new IKeyBinding(){

            @Override
            public Component keyName() {
                return binding.getTranslatedKeyMessage();
            }

            @Override
            public IKeyModifier keyModifier() {
                return binding.getOpenKeyModifier();
            }
        };
        return (T)((IKeyBinding)Objects.unsafeCast(binding1));
    }

    private static OnceKeyBinding createKeyBinding(String description, IKeyModifier keyModifier, InputConstants.Key keyCode, String category) {
        return new OnceKeyBinding(description, keyModifier, keyCode, category);
    }

    private static <T> ArrayList<T> createAndAttach() {
        EventBus.register(RenderFrameEvent.Post.class, event -> INPUTS.forEach((Consumer<Pair<KeyMapping, Supplier<Runnable>>>)((Consumer<Pair>)pair -> {
            if (((KeyMapping)pair.getKey()).consumeClick()) {
                ((Runnable)((Supplier)pair.getValue()).get()).run();
            }
        })));
        return new ArrayList();
    }

    public static class OnceKeyBinding
    extends AbstractForgeKeyMapping {
        private boolean canConsumeClick = true;

        public OnceKeyBinding(String description, IKeyModifier keyModifier, InputConstants.Key keyCode, String category) {
            super(description, keyModifier, keyCode, category);
        }

        @Override
        public boolean consumeClick() {
            if (this.canConsumeClick && this.isDown()) {
                this.canConsumeClick = false;
                return true;
            }
            return false;
        }

        public void setDown(boolean isDown) {
            super.setDown(isDown);
            if (!isDown) {
                this.canConsumeClick = true;
            }
        }
    }
}

