/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.OptimizeContext;

@FunctionalInterface
public interface OptimizedExpression<T> {
    public T evaluate(ExecutionContext var1);

    default public boolean isConstant() {
        return false;
    }

    public static OptimizedExpression<OpenVector2f> of(Expression x, Expression y) {
        final OpenVector2f variable = new OpenVector2f();
        OptimizeContext optimizeContext = OptimizeContext.DEFAULT;
        if (y.isMutable()) {
            if (x.isMutable()) {
                return context -> {
                    variable.setX((float)x.compute(context));
                    variable.setY((float)y.compute(context));
                    return variable;
                };
            }
            variable.setX((float)x.compute(optimizeContext));
            return context -> {
                variable.setY((float)y.compute(context));
                return variable;
            };
        }
        variable.setY((float)y.compute(optimizeContext));
        if (x.isMutable()) {
            return context -> {
                variable.setX((float)x.compute(context));
                return variable;
            };
        }
        variable.setX((float)x.compute(optimizeContext));
        return new OptimizedExpression<OpenVector2f>(){

            @Override
            public OpenVector2f evaluate(ExecutionContext context) {
                return variable;
            }

            @Override
            public boolean isConstant() {
                return true;
            }
        };
    }

    public static OptimizedExpression<OpenVector3f> of(Expression x, Expression y, Expression z) {
        final OpenVector3f variable = new OpenVector3f();
        OptimizeContext optimizeContext = OptimizeContext.DEFAULT;
        if (z.isMutable()) {
            if (y.isMutable()) {
                if (x.isMutable()) {
                    return context -> {
                        variable.setX((float)x.compute(context));
                        variable.setY((float)y.compute(context));
                        variable.setZ((float)z.compute(context));
                        return variable;
                    };
                }
                variable.setX((float)x.compute(optimizeContext));
                return context -> {
                    variable.setY((float)y.compute(context));
                    variable.setZ((float)z.compute(context));
                    return variable;
                };
            }
            variable.setY((float)y.compute(optimizeContext));
            if (x.isMutable()) {
                return context -> {
                    variable.setX((float)x.compute(context));
                    variable.setZ((float)z.compute(context));
                    return variable;
                };
            }
            variable.setX((float)x.compute(optimizeContext));
            return context -> {
                variable.setZ((float)z.compute(context));
                return variable;
            };
        }
        variable.setZ((float)z.compute(optimizeContext));
        if (y.isMutable()) {
            if (x.isMutable()) {
                return context -> {
                    variable.setX((float)x.compute(context));
                    variable.setY((float)y.compute(context));
                    return variable;
                };
            }
            variable.setX((float)x.compute(optimizeContext));
            return context -> {
                variable.setY((float)y.compute(context));
                return variable;
            };
        }
        variable.setY((float)y.compute(optimizeContext));
        if (x.isMutable()) {
            return context -> {
                variable.setX((float)x.compute(context));
                return variable;
            };
        }
        variable.setX((float)x.compute(optimizeContext));
        return new OptimizedExpression<OpenVector3f>(){

            @Override
            public OpenVector3f evaluate(ExecutionContext context) {
                return variable;
            }

            @Override
            public boolean isConstant() {
                return true;
            }
        };
    }
}

