/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.security.SecureRandom;

public class OpenUUID {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final char[] ALPHABET = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz1234567890".toCharArray();
    private final String value;

    public OpenUUID() {
        this(RANDOM.nextLong());
    }

    public OpenUUID(long ... values) {
        int idx = 0;
        int[] words = new int[10];
        for (long value : values) {
            while (value != 0L) {
                int assignTransformLhsTemp22 = idx % 10;
                int cfr_ignored_0 = words[assignTransformLhsTemp22] + (int)(value % 62L);
                value /= 62L;
                ++idx;
            }
        }
        StringBuilder builder = new StringBuilder(10);
        for (int word : words) {
            builder.append(ALPHABET[Math.abs(word % 62)]);
        }
        this.value = builder.reverse().toString();
    }

    public OpenUUID(String value) {
        this.value = value;
    }

    public static OpenUUID randomUUID() {
        return new OpenUUID();
    }

    public static String randomUUIDString() {
        return OpenUUID.randomUUID().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenUUID)) {
            return false;
        }
        OpenUUID that = (OpenUUID)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

