/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.util.Objects;

public class OpenPrimitive {
    public static final OpenPrimitive NULL = new OpenPrimitive(null);
    public static final OpenPrimitive TRUE = new OpenPrimitive(true);
    public static final OpenPrimitive FALSE = new OpenPrimitive(false);
    public static final OpenPrimitive INT_ZERO = new OpenPrimitive(0);
    public static final OpenPrimitive FLOAT_ZERO = new OpenPrimitive(Float.valueOf(0.0f));
    public static final OpenPrimitive DOUBLE_ZERO = new OpenPrimitive(0.0);
    public static final OpenPrimitive EMPTY_STRING = new OpenPrimitive("");
    private final Object value;

    private OpenPrimitive(Object value) {
        this.value = value;
    }

    public static OpenPrimitive of(boolean value) {
        if (value) {
            return TRUE;
        }
        return FALSE;
    }

    public static OpenPrimitive of(byte value) {
        return new OpenPrimitive(value);
    }

    public static OpenPrimitive of(short value) {
        return new OpenPrimitive(value);
    }

    public static OpenPrimitive of(int value) {
        return new OpenPrimitive(value);
    }

    public static OpenPrimitive of(long value) {
        return new OpenPrimitive(value);
    }

    public static OpenPrimitive of(float value) {
        return new OpenPrimitive(Float.valueOf(value));
    }

    public static OpenPrimitive of(double value) {
        return new OpenPrimitive(value);
    }

    public static OpenPrimitive of(String value) {
        return new OpenPrimitive(value);
    }

    public OpenPrimitive negative() {
        Object object = this.value;
        if (object instanceof Boolean) {
            Boolean booleanValue = (Boolean)object;
            return OpenPrimitive.of(booleanValue == false);
        }
        object = this.value;
        if (object instanceof Byte) {
            Byte byteValue = (Byte)object;
            return OpenPrimitive.of((int)(-byteValue.byteValue()));
        }
        object = this.value;
        if (object instanceof Short) {
            Short shortValue = (Short)object;
            return OpenPrimitive.of((int)(-shortValue.shortValue()));
        }
        object = this.value;
        if (object instanceof Integer) {
            Integer integerValue = (Integer)object;
            return OpenPrimitive.of(-integerValue.intValue());
        }
        object = this.value;
        if (object instanceof Long) {
            Long longValue = (Long)object;
            return OpenPrimitive.of(-longValue.longValue());
        }
        object = this.value;
        if (object instanceof Float) {
            Float floatValue = (Float)object;
            return OpenPrimitive.of(-floatValue.floatValue());
        }
        object = this.value;
        if (object instanceof Double) {
            Double doubleValue = (Double)object;
            return OpenPrimitive.of(-doubleValue.doubleValue());
        }
        object = this.value;
        if (object instanceof String) {
            String stringValue = (String)object;
            Object fixed = "-(" + stringValue + ")";
            if (((String)fixed).startsWith("-(-(") && ((String)fixed).endsWith("))")) {
                fixed = ((String)fixed).substring(4, ((String)fixed).length() - 2);
            }
            return OpenPrimitive.of((String)fixed);
        }
        return this;
    }

    public boolean booleanValue() {
        Object object = this.value;
        if (object instanceof Boolean) {
            Boolean booleanValue = (Boolean)object;
            return booleanValue;
        }
        object = this.value;
        if (object instanceof Byte) {
            Byte byteValue = (Byte)object;
            return byteValue != 0;
        }
        object = this.value;
        if (object instanceof Short) {
            Short shortValue = (Short)object;
            return shortValue != 0;
        }
        object = this.value;
        if (object instanceof Integer) {
            Integer integerValue = (Integer)object;
            return integerValue != 0;
        }
        object = this.value;
        if (object instanceof Long) {
            Long longValue = (Long)object;
            return longValue != 0L;
        }
        object = this.value;
        if (object instanceof Float) {
            Float floatValue = (Float)object;
            return floatValue.floatValue() != 0.0f;
        }
        object = this.value;
        if (object instanceof Double) {
            Double doubleValue = (Double)object;
            return doubleValue != 0.0;
        }
        object = this.value;
        if (object instanceof String) {
            String stringValue = (String)object;
            return !stringValue.isEmpty();
        }
        return false;
    }

    public byte byteValue() {
        return this.numberValue().byteValue();
    }

    public short shortValue() {
        return this.numberValue().shortValue();
    }

    public int intValue() {
        return this.numberValue().intValue();
    }

    public long longValue() {
        return this.numberValue().longValue();
    }

    public float floatValue() {
        return this.numberValue().floatValue();
    }

    public double doubleValue() {
        return this.numberValue().doubleValue();
    }

    public String stringValue() {
        Object object = this.value;
        if (object instanceof Number) {
            Number numberValue = (Number)object;
            return numberValue.toString();
        }
        object = this.value;
        if (object instanceof String) {
            String stringValue = (String)object;
            return stringValue;
        }
        return "";
    }

    public Number numberValue() {
        Object object = this.value;
        if (object instanceof Number) {
            Number numberValue = (Number)object;
            return numberValue;
        }
        return 0;
    }

    public Object rawValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenPrimitive)) {
            return false;
        }
        OpenPrimitive that = (OpenPrimitive)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "null";
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public boolean isString() {
        return this.value instanceof String;
    }
}

