/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import moe.plushie.armourers_workshop.api.skin.texture.ISkinTexturePos;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureOptions;
import moe.plushie.armourers_workshop.core.utils.Objects;
import org.jetbrains.annotations.Nullable;

public class SkinTexturePos
implements ISkinTexturePos {
    public static final SkinTexturePos DEFAULT = new SkinTexturePos(0.0f, 0.0f, 1.0f, 1.0f, 256.0f, 256.0f);
    protected final float u;
    protected final float v;
    protected final float width;
    protected final float height;
    protected final float totalWidth;
    protected final float totalHeight;
    protected final SkinTextureOptions options;
    protected final SkinTextureData provider;

    public SkinTexturePos(float u, float v, float width, float height, SkinTextureData provider) {
        this(u, v, width, height, provider.width(), provider.height(), null, provider);
    }

    public SkinTexturePos(float u, float v, float width, float height, SkinTextureOptions options, SkinTextureData provider) {
        this(u, v, width, height, provider.width(), provider.height(), options, provider);
    }

    public SkinTexturePos(float u, float v, float width, float height, float totalWidth, float totalHeight) {
        this(u, v, width, height, totalWidth, totalHeight, null, null);
    }

    public SkinTexturePos(float u, float v, float width, float height, float totalWidth, float totalHeight, SkinTextureOptions options, SkinTextureData provider) {
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.totalWidth = totalWidth;
        this.totalHeight = totalHeight;
        this.options = options;
        this.provider = provider;
    }

    @Override
    public float u() {
        return this.u;
    }

    @Override
    public float v() {
        return this.v;
    }

    @Override
    public float width() {
        return this.width;
    }

    @Override
    public float height() {
        return this.height;
    }

    @Override
    public float totalWidth() {
        return this.totalWidth;
    }

    @Override
    public float totalHeight() {
        return this.totalHeight;
    }

    @Override
    public SkinTextureOptions options() {
        return this.options;
    }

    @Override
    @Nullable
    public SkinTextureData provider() {
        return this.provider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinTexturePos)) {
            return false;
        }
        SkinTexturePos that = (SkinTexturePos)o;
        return Float.compare(that.u, this.u) == 0 && Float.compare(that.v, this.v) == 0 && Float.compare(that.width, this.width) == 0 && Float.compare(that.height, this.height) == 0 && Float.compare(that.totalWidth, this.totalWidth) == 0 && Float.compare(that.totalHeight, this.totalHeight) == 0 && that.options == this.options;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.u), Float.valueOf(this.v), Float.valueOf(this.width), Float.valueOf(this.height), Float.valueOf(this.totalWidth), Float.valueOf(this.totalHeight), this.options);
    }

    public String toString() {
        return Objects.toString(this, "uv", new OpenVector2i(this.u, this.v), "size", new OpenVector2i(this.width, this.height), "total", new OpenVector2i(this.totalWidth, this.totalHeight), "options", this.options);
    }
}

