/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import moe.plushie.armourers_workshop.api.skin.texture.ISkinTextureOptions;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class SkinTextureOptions
implements ISkinTextureOptions {
    private long value = 0L;
    private int rotation = 0;

    public SkinTextureOptions() {
    }

    public SkinTextureOptions(long value) {
        this.value = value;
        this.rotation = this.opt2rot((int)value & 0xF);
    }

    public void setRotation(int rotation) {
        this.value &= 0xFFFFFFFFFFFFFFF0L;
        this.value |= (long)this.rot2opt(rotation);
        this.rotation = rotation;
    }

    @Override
    public int rotation() {
        return this.rotation;
    }

    @Override
    public boolean isEmpty() {
        return this.value == 0L;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinTextureOptions)) {
            return false;
        }
        SkinTextureOptions that = (SkinTextureOptions)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.format("[rotation=%d]", this.rotation);
    }

    private int opt2rot(int opt) {
        return switch (opt) {
            case 1 -> 90;
            case 2 -> 180;
            case 3 -> 270;
            default -> 0;
        };
    }

    private int rot2opt(int rot) {
        return switch (rot) {
            case 90 -> 1;
            case 180 -> 2;
            case 270 -> 3;
            default -> 0;
        };
    }
}

