/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.sound;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.api.skin.sound.ISkinSoundProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class SkinSoundProperties
implements ISkinSoundProperties {
    public static final SkinSoundProperties EMPTY = new SkinSoundProperties();
    private static final SkinProperty<Float> VOLUME = SkinProperty.normal("Volume", Float.valueOf(1.0f));
    private static final SkinProperty<Float> PITCH = SkinProperty.normal("Pitch", Float.valueOf(1.0f));
    private int flags = 0;
    private final SkinProperties storage = new SkinProperties();

    public void readFromStream(IInputStream stream) throws IOException {
        this.flags = stream.readInt();
        if ((this.flags & Integer.MIN_VALUE) != 0) {
            this.storage.readFromStream(stream);
        }
    }

    public void writeToStream(IOutputStream stream) throws IOException {
        if (this.storage.isEmpty()) {
            stream.writeInt(this.flags);
        } else {
            stream.writeInt(this.flags | Integer.MIN_VALUE);
            this.storage.writeToStream(stream);
        }
    }

    public <T> void set(ISkinProperty<T> property, T value) {
        this.storage.put(property, value);
    }

    public <T> T get(ISkinProperty<T> property) {
        return this.storage.get(property);
    }

    public void setVolume(float volume) {
        this.storage.put(VOLUME, Float.valueOf(volume));
    }

    @Override
    public float volume() {
        return this.storage.get(VOLUME).floatValue();
    }

    public void setPitch(float pitch) {
        this.storage.put(PITCH, Float.valueOf(pitch));
    }

    @Override
    public float pitch() {
        return this.storage.get(PITCH).floatValue();
    }

    public SkinSoundProperties copy() {
        SkinSoundProperties properties = new SkinSoundProperties();
        properties.flags = this.flags;
        properties.storage.putAll(this.storage);
        return properties;
    }

    public String toString() {
        SkinProperties properties = this.storage.copy();
        return properties.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinSoundProperties)) {
            return false;
        }
        SkinSoundProperties that = (SkinSoundProperties)o;
        return this.flags == that.flags && this.storage.equals(that.storage);
    }

    public int hashCode() {
        return Objects.hash(this.flags, this.storage);
    }

    private void setFlag(int bit, boolean value) {
        this.flags = value ? (this.flags |= 1 << bit) : (this.flags &= ~(1 << bit));
    }

    private boolean getFlag(int bit) {
        return (this.flags & 1 << bit) != 0;
    }
}

