/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleData;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleMaterial;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.EmitterInitialLocalSpace;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.EmitterInitialization;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterEventLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterExpressionLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterLoopingLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime.EmitterOnceLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.rate.EmitterInstantRate;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.rate.EmitterManualRate;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.rate.EmitterSteadyRate;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterBoxShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterDiscShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterEntityShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterPointShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterSphereShape;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.ParticleInitialSpeed;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.ParticleInitialSpin;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.ParticleInitialization;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.appearance.ParticleBillboardAppearance;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.appearance.ParticleLightingAppearance;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.appearance.ParticleTintingAppearance;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleEventLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleExpressLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleKillInBlocksLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleKillInPlaneLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime.ParticleOnlyInBlocksLifetime;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.motion.ParticleCollisionMotion;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.motion.ParticleDynamicMotion;
import moe.plushie.armourers_workshop.core.skin.particle.component.particle.motion.ParticleParametricMotion;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOFunction;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFile;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkTextureData;
import moe.plushie.armourers_workshop.core.utils.Collections;

public class ChunkParticleData {
    private SkinParticleData particle;

    public ChunkParticleData() {
    }

    public ChunkParticleData(SkinParticleData particle) {
        this.particle = particle;
    }

    public void readFromStream(ChunkInputStream stream) throws IOException {
        ChunkFile file = stream.readFile();
        final ChunkContext context = stream.context();
        final DataInputStream inputStream = new DataInputStream((InputStream)new ByteBufInputStream(file.bytes()));
        this.particle = this.readContentFromStream(file.name(), new ChunkInputStream(){

            @Override
            public DataInputStream inputStream() {
                return inputStream;
            }

            @Override
            public ChunkContext context() {
                return context;
            }
        });
    }

    public void writeToStream(ChunkOutputStream stream) throws IOException {
        ByteBuf bytes = Unpooled.buffer((int)1024);
        final ChunkContext context = stream.context();
        final DataOutputStream outputStream = new DataOutputStream((OutputStream)new ByteBufOutputStream(bytes));
        this.writeContentToStream(this.particle, new ChunkOutputStream(){

            @Override
            public DataOutputStream outputStream() {
                return outputStream;
            }

            @Override
            public ChunkContext context() {
                return context;
            }
        });
        outputStream.close();
        stream.writeFile(ChunkFile.particle(this.particle.name(), bytes));
    }

    private SkinParticleData readContentFromStream(String name, ChunkInputStream stream) throws IOException {
        ChunkTextureData textureData = new ChunkTextureData();
        SkinParticleMaterial material = stream.readEnum(SkinParticleMaterial.class);
        textureData.readFromStream(stream);
        ArrayList<SkinParticleComponent> components = new ArrayList<SkinParticleComponent>();
        int componentSize = stream.readVarInt();
        for (int i = 0; i < componentSize; ++i) {
            int componentId = stream.readVarInt();
            Serializer<?> serializer = Serializer.ID_TO_SERIALIZERS.get(componentId);
            if (serializer == null) {
                throw new IOException("can't found serializer of the component id: " + componentId);
            }
            components.add((SkinParticleComponent)serializer.decoder.apply(stream));
        }
        return new SkinParticleData(name, material, textureData.texture(), components);
    }

    private void writeContentToStream(SkinParticleData particle, ChunkOutputStream stream) throws IOException {
        ChunkTextureData textureData = new ChunkTextureData(particle.texture());
        textureData.setId(1);
        textureData.freeze(0.0f, 0.0f, p -> null);
        stream.writeEnum(particle.material());
        textureData.writeToStream(stream);
        stream.writeVarInt(particle.components().size());
        for (SkinParticleComponent skinParticleComponent : particle.components()) {
            Serializer<?> serializer = Serializer.CLASS_TO_SERIALIZERS.get(skinParticleComponent.getClass());
            if (serializer == null) {
                throw new IOException("can't found serializer of the component: " + String.valueOf(skinParticleComponent.getClass()));
            }
            stream.writeVarInt(serializer.id);
            skinParticleComponent.writeToStream(stream);
        }
    }

    public SkinParticleData particle() {
        return this.particle;
    }

    private static class Serializer<T extends SkinParticleComponent> {
        private static final Map<Integer, Serializer<?>> ID_TO_SERIALIZERS = new HashMap();
        private static final Map<Class<?>, Serializer<?>> CLASS_TO_SERIALIZERS = new HashMap();
        private static final List<Serializer<?>> ALL_SERIALIZERS = Collections.immutableList(it -> {
            it.add(Serializer.define(0, EmitterInitialization.class, EmitterInitialization::new));
            it.add(Serializer.define(1, EmitterInitialLocalSpace.class, EmitterInitialLocalSpace::new));
            it.add(Serializer.define(2, EmitterEventLifetime.class, EmitterEventLifetime::new));
            it.add(Serializer.define(3, EmitterExpressionLifetime.class, EmitterExpressionLifetime::new));
            it.add(Serializer.define(4, EmitterLoopingLifetime.class, EmitterLoopingLifetime::new));
            it.add(Serializer.define(5, EmitterOnceLifetime.class, EmitterOnceLifetime::new));
            it.add(Serializer.define(6, EmitterInstantRate.class, EmitterInstantRate::new));
            it.add(Serializer.define(7, EmitterManualRate.class, EmitterManualRate::new));
            it.add(Serializer.define(8, EmitterSteadyRate.class, EmitterSteadyRate::new));
            it.add(Serializer.define(9, EmitterBoxShape.class, EmitterBoxShape::new));
            it.add(Serializer.define(10, EmitterDiscShape.class, EmitterDiscShape::new));
            it.add(Serializer.define(11, EmitterEntityShape.class, EmitterEntityShape::new));
            it.add(Serializer.define(12, EmitterPointShape.class, EmitterPointShape::new));
            it.add(Serializer.define(13, EmitterSphereShape.class, EmitterSphereShape::new));
            it.add(Serializer.define(14, ParticleInitialization.class, ParticleInitialization::new));
            it.add(Serializer.define(15, ParticleInitialSpeed.class, ParticleInitialSpeed::new));
            it.add(Serializer.define(16, ParticleInitialSpin.class, ParticleInitialSpin::new));
            it.add(Serializer.define(17, ParticleEventLifetime.class, ParticleEventLifetime::new));
            it.add(Serializer.define(18, ParticleExpressLifetime.class, ParticleExpressLifetime::new));
            it.add(Serializer.define(19, ParticleKillInBlocksLifetime.class, ParticleKillInBlocksLifetime::new));
            it.add(Serializer.define(20, ParticleKillInPlaneLifetime.class, ParticleKillInPlaneLifetime::new));
            it.add(Serializer.define(21, ParticleOnlyInBlocksLifetime.class, ParticleOnlyInBlocksLifetime::new));
            it.add(Serializer.define(22, ParticleCollisionMotion.class, ParticleCollisionMotion::new));
            it.add(Serializer.define(23, ParticleDynamicMotion.class, ParticleDynamicMotion::new));
            it.add(Serializer.define(24, ParticleParametricMotion.class, ParticleParametricMotion::new));
            it.add(Serializer.define(25, ParticleBillboardAppearance.class, ParticleBillboardAppearance::new));
            it.add(Serializer.define(26, ParticleLightingAppearance.class, ParticleLightingAppearance::new));
            it.add(Serializer.define(27, ParticleTintingAppearance.class, ParticleTintingAppearance::new));
        });
        private final int id;
        private final Class<T> clazz;
        private final IOFunction<IInputStream, T> decoder;

        private Serializer(int id, Class<T> clazz, IOFunction<IInputStream, T> decoder) {
            this.id = id;
            this.clazz = clazz;
            this.decoder = decoder;
            ID_TO_SERIALIZERS.put(id, this);
            CLASS_TO_SERIALIZERS.put(clazz, this);
        }

        private static <T extends SkinParticleComponent> Serializer<T> define(int id, Class<T> clazz, IOFunction<IInputStream, T> decoder) {
            return new Serializer<T>(id, clazz, decoder);
        }
    }
}

