/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer;

import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import net.minecraft.nbt.CompoundTag;

public class SkinFileOptions {
    private final CompoundTag values;
    private final TagSerializer serializer;

    public SkinFileOptions() {
        this(new CompoundTag());
    }

    public SkinFileOptions(CompoundTag compoundTag) {
        this.values = compoundTag;
        this.serializer = new TagSerializer(compoundTag);
    }

    public CompoundTag serializeNBT() {
        return this.values.copy();
    }

    public void merge(SkinFileOptions options) {
        if (options != null) {
            int fileVersion = Math.max(this.fileVersion(), options.fileVersion());
            this.values.merge(options.values);
            this.setFileVersion(fileVersion);
        }
    }

    public void setFileVersion(int fileVersion) {
        this.serializer.write(CodingKeys.FILE_VERSION, fileVersion);
    }

    public int fileVersion() {
        return this.serializer.read(CodingKeys.FILE_VERSION);
    }

    public void setEditable(boolean newValue) {
        this.serializer.write(CodingKeys.IS_EDITABLE, newValue);
    }

    public boolean getEditable(boolean defaultValue) {
        Boolean value = this.serializer.read(CodingKeys.IS_EDITABLE);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean isEditable() {
        return this.getEditable(true);
    }

    public void setSavable(boolean newValue) {
        this.serializer.write(CodingKeys.IS_SAVABLE, newValue);
    }

    public boolean getSavable(boolean defaultValue) {
        Boolean value = this.serializer.read(CodingKeys.IS_SAVABLE);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean isSavable() {
        return this.getSavable(true);
    }

    public void setExportable(boolean newValue) {
        this.serializer.write(CodingKeys.IS_EXPORTABLE, newValue);
    }

    public boolean getExportable(boolean defaultValue) {
        Boolean value = this.serializer.read(CodingKeys.IS_EXPORTABLE);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean isExportable() {
        return this.getExportable(true);
    }

    public void setEncrypted(boolean newValue) {
        this.serializer.write(CodingKeys.IS_ENCRYPTED, newValue);
    }

    public boolean getEncrypted(boolean defaultValue) {
        Boolean value = this.serializer.read(CodingKeys.IS_ENCRYPTED);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean isEncrypted() {
        return this.getEncrypted(false);
    }

    public void setCompressed(boolean newValue) {
        this.serializer.write(CodingKeys.IS_COMPRESSED, newValue);
    }

    public boolean getCompressed(boolean defaultValue) {
        Boolean value = this.serializer.read(CodingKeys.IS_COMPRESSED);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean isCompressed() {
        return this.getCompressed(false);
    }

    public void setSecurityKey(String securityKey) {
        this.serializer.write(CodingKeys.SECURITY_KEY, securityKey);
    }

    public String securityKey() {
        return this.serializer.read(CodingKeys.SECURITY_KEY);
    }

    public void setSecurityData(String securityData) {
        this.serializer.write(CodingKeys.SECURITY_DATA, securityData);
    }

    public String securityData() {
        return this.serializer.read(CodingKeys.SECURITY_DATA);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinFileOptions)) {
            return false;
        }
        SkinFileOptions options = (SkinFileOptions)o;
        return this.values.equals((Object)options.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return this.values.toString();
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<Integer> FILE_VERSION = IDataSerializerKey.create("FileVersion", IDataCodec.INT, 0);
        public static final IDataSerializerKey<Boolean> IS_EDITABLE = IDataSerializerKey.create("Editable", IDataCodec.BOOL, null);
        public static final IDataSerializerKey<Boolean> IS_SAVABLE = IDataSerializerKey.create("Savable", IDataCodec.BOOL, null);
        public static final IDataSerializerKey<Boolean> IS_EXPORTABLE = IDataSerializerKey.create("Exportable", IDataCodec.BOOL, null);
        public static final IDataSerializerKey<Boolean> IS_ENCRYPTED = IDataSerializerKey.create("Encrypted", IDataCodec.BOOL, null);
        public static final IDataSerializerKey<Boolean> IS_COMPRESSED = IDataSerializerKey.create("Compressed", IDataCodec.BOOL, null);
        public static final IDataSerializerKey<String> SECURITY_KEY = IDataSerializerKey.create("SecurityKey", IDataCodec.STRING, null);
        public static final IDataSerializerKey<String> SECURITY_DATA = IDataSerializerKey.create("SecurityData", IDataCodec.STRING, null);

        private CodingKeys() {
        }
    }
}

