/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.property;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenProperties;
import net.minecraft.nbt.CompoundTag;

public class SkinProperties
extends OpenProperties
implements ISkinProperties {
    public static final SkinProperties EMPTY = new SkinProperties();
    public static final IDataCodec<SkinProperties> CODEC = IDataCodec.COMPOUND_TAG.xmap(SkinProperties::new, OpenProperties::serializeNBT);

    public SkinProperties() {
    }

    public SkinProperties(CompoundTag tag) {
        this();
        this.readFromNBT(tag);
    }

    protected SkinProperties(LinkedHashMap<String, Object> properties) {
        super(properties);
    }

    @Override
    public <T> T get(ISkinProperty<T> property) {
        Object value = this.getOrDefault(property.key(), property.defaultValue());
        return Objects.unsafeCast(value);
    }

    @Override
    public <T> void put(ISkinProperty<T> property, T value) {
        if (this.shouldRemoveDefaultValues() && Objects.equals(value, property.defaultValue())) {
            this.remove(property.key());
        } else {
            this.put(property.key(), value);
        }
    }

    @Override
    public <T> void remove(ISkinProperty<T> property) {
        this.remove(property.key());
    }

    @Override
    public <T> boolean containsKey(ISkinProperty<T> property) {
        return this.containsKey(property.key());
    }

    @Override
    public <T> boolean containsValue(ISkinProperty<T> property) {
        return this.containsValue(property.key());
    }

    public boolean shouldRemoveDefaultValues() {
        return true;
    }

    public ArrayList<String> getPropertiesList() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.properties.size(); ++i) {
            String key = (String)this.properties.keySet().toArray()[i];
            list.add(key + ":" + String.valueOf(this.properties.get(key)));
        }
        return list;
    }

    @Override
    public OpenProperties empty() {
        return new SkinProperties();
    }

    @Override
    public SkinProperties copy() {
        return new SkinProperties(new LinkedHashMap<String, Object>(this.properties));
    }

    public SkinProperties slice(String index) {
        return new Stub(this, index);
    }

    public static class Stub
    extends SkinProperties {
        private final String index;

        public Stub(SkinProperties parent, String index) {
            super(parent.properties);
            this.index = index;
        }

        @Override
        public <T> void put(ISkinProperty<T> property, T value) {
            this.put(this.resolveKey(property), value);
        }

        @Override
        public <T> void remove(ISkinProperty<T> property) {
            this.remove(this.resolveKey(property));
        }

        @Override
        public <T> T get(ISkinProperty<T> property) {
            Object value = this.getOrDefault(this.resolveKey(property), property.defaultValue());
            return Objects.unsafeCast(value);
        }

        @Override
        public <T> boolean containsKey(ISkinProperty<T> property) {
            return this.containsKey(this.resolveKey(property));
        }

        @Override
        public <T> boolean containsValue(ISkinProperty<T> property) {
            return this.containsValue(this.resolveKey(property));
        }

        private <T> String resolveKey(ISkinProperty<T> property) {
            return property.key() + this.index;
        }
    }

    public static class Increment
    extends SkinProperties {
        @Override
        public boolean shouldRemoveDefaultValues() {
            return false;
        }
    }
}

