/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.particle.appearance;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class ParticleTintingAppearance
extends SkinParticleComponent {
    private final ColorComponent color;

    public ParticleTintingAppearance(OpenPrimitive interpolation, Map<Float, Integer> gradientValues) {
        this.color = new GradientColor(interpolation, gradientValues);
    }

    public ParticleTintingAppearance(OpenPrimitive red, OpenPrimitive green, OpenPrimitive blue, OpenPrimitive alpha) {
        this.color = new SolidColor(red, green, blue, alpha);
    }

    public ParticleTintingAppearance(IInputStream stream) throws IOException {
        boolean isGradient = stream.readBoolean();
        this.color = isGradient ? new GradientColor(stream) : new SolidColor(stream);
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writeBoolean(this.color instanceof GradientColor);
        this.color.writeToStream(stream);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        this.color.applyToBuilder(builder);
    }

    private static class GradientColor
    implements ColorComponent {
        private final OpenPrimitive interpolation;
        private final Map<Float, Integer> gradientValues;

        private GradientColor(OpenPrimitive interpolation, Map<Float, Integer> gradientValues) {
            this.interpolation = interpolation;
            this.gradientValues = gradientValues;
        }

        public GradientColor(IInputStream stream) throws IOException {
            this.interpolation = stream.readPrimitiveObject();
            this.gradientValues = new LinkedHashMap<Float, Integer>();
            int size = stream.readVarInt();
            for (int i = 0; i < size; ++i) {
                float key = stream.readFloat();
                int value = stream.readInt();
                this.gradientValues.put(Float.valueOf(key), value);
            }
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            stream.writePrimitiveObject(this.interpolation);
            stream.writeVarInt(this.gradientValues.size());
            for (Map.Entry<Float, Integer> entry : this.gradientValues.entrySet()) {
                stream.writeFloat(entry.getKey().floatValue());
                stream.writeInt(entry.getValue());
            }
        }

        @Override
        public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
            Expression interpolation = builder.compile(this.interpolation, 1.0);
            builder.renderParticlePre((emitter, particle, partialTicks, context) -> {
                double factor = interpolation.compute(context);
            });
        }
    }

    private static interface ColorComponent {
        public void writeToStream(IOutputStream var1) throws IOException;

        public void applyToBuilder(SkinParticleBuilder var1) throws Exception;
    }

    private static class SolidColor
    implements ColorComponent {
        private final OpenPrimitive red;
        private final OpenPrimitive green;
        private final OpenPrimitive blue;
        private final OpenPrimitive alpha;

        private SolidColor(OpenPrimitive red, OpenPrimitive green, OpenPrimitive blue, OpenPrimitive alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public SolidColor(IInputStream stream) throws IOException {
            this.red = stream.readPrimitiveObject();
            this.green = stream.readPrimitiveObject();
            this.blue = stream.readPrimitiveObject();
            this.alpha = stream.readPrimitiveObject();
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            stream.writePrimitiveObject(this.red);
            stream.writePrimitiveObject(this.green);
            stream.writePrimitiveObject(this.blue);
            stream.writePrimitiveObject(this.alpha);
        }

        @Override
        public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
            Expression red = builder.compile(this.red, 1.0);
            Expression green = builder.compile(this.green, 1.0);
            Expression blue = builder.compile(this.blue, 1.0);
            Expression alpha = builder.compile(this.alpha, 1.0);
            builder.renderParticlePre((emitter, particle, partialTicks, context) -> {
                double r = red.compute(context);
                double g = green.compute(context);
                double b = blue.compute(context);
                double a = alpha.compute(context);
                particle.setColor((float)r, (float)g, (float)b, (float)a);
            });
        }
    }
}

