/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.thirdparty.function;

import java.util.List;
import moe.plushie.armourers_workshop.core.client.animation.AnimationManager;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.function.Function;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.BlockEntitySelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EntitySelectorImpl;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import net.minecraft.nbt.CompoundTag;

public class PlayAnimationFunction
extends Function {
    private final Expression name;

    public PlayAnimationFunction(Expression receiver, List<Expression> arguments) {
        super(receiver, 1, arguments);
        this.name = arguments.get(0);
    }

    @Override
    public double compute(ExecutionContext context) {
        AnimationManager target = this.getTarget(context);
        if (target == null) {
            return 0.0;
        }
        String name = this.name.evaluate(context).getAsString();
        if (name.isEmpty()) {
            return 0.0;
        }
        target.play(name, TickUtils.animationTicks(), new CompoundTag());
        return 0.0;
    }

    private AnimationManager getTarget(ExecutionContext context) {
        if (context instanceof EntitySelectorImpl) {
            EntitySelectorImpl entity = (EntitySelectorImpl)((Object)context);
            return AnimationManager.of(entity.entity());
        }
        if (context instanceof BlockEntitySelectorImpl) {
            BlockEntitySelectorImpl entity = (BlockEntitySelectorImpl)((Object)context);
            return AnimationManager.of(entity.getEntity());
        }
        return null;
    }
}

