/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.compatibility.core.AbstractRegistryManager;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.LivingEntity.EquipmentItemProvider;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.MathHelper;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.EffectSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.ItemSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.LivingEntitySelector;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ContextSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EffectSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EntitySelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ItemSelectorImpl;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenEquipmentSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LivingEntitySelectorImpl<T extends LivingEntity>
extends EntitySelectorImpl<T>
implements LivingEntitySelector {
    private static final Map<String, Optional<OpenEquipmentSlot>> NAMED_SLOTS = new ConcurrentHashMap<String, Optional<OpenEquipmentSlot>>();
    private static final Map<String, OpenEquipmentSlot> FIXED_SLOTS = Collections.immutableMap(it -> {
        it.put((Object)"chest", (Object)OpenEquipmentSlot.CHEST);
        it.put((Object)"feet", (Object)OpenEquipmentSlot.FEET);
        it.put((Object)"head", (Object)OpenEquipmentSlot.HEAD);
        it.put((Object)"legs", (Object)OpenEquipmentSlot.LEGS);
        it.put((Object)"mainhand", (Object)OpenEquipmentSlot.MAINHAND);
        it.put((Object)"offhand", (Object)OpenEquipmentSlot.OFFHAND);
        it.put((Object)"body", (Object)OpenEquipmentSlot.BODY);
    });
    private final ItemSelectorImpl itemSelector = new ItemSelectorImpl();
    private final EffectSelectorImpl effectSelector = new EffectSelectorImpl();

    @Override
    public LivingEntitySelectorImpl<T> apply(T entity, ContextSelectorImpl context) {
        super.apply(entity, context);
        return this;
    }

    @Override
    public double bodyYaw() {
        return MathHelper.lerp(this.partialTick(), ((LivingEntity)this.entity).xRotO, ((LivingEntity)this.entity).getXRot());
    }

    @Override
    public double bodyPitch() {
        return MathHelper.wrapDegrees(MathHelper.lerp(this.partialTick(), ((LivingEntity)this.entity).yRotO, ((LivingEntity)this.entity).getYRot()));
    }

    @Override
    public double health() {
        return ((LivingEntity)this.entity).getHealth();
    }

    @Override
    public double maxHealth() {
        return ((LivingEntity)this.entity).getMaxHealth();
    }

    @Override
    public double armorValue() {
        return ((LivingEntity)this.entity).getArmorValue();
    }

    @Override
    public double hurtTime() {
        return ((LivingEntity)this.entity).hurtTime;
    }

    @Override
    public boolean isDeadOrDying() {
        return ((LivingEntity)this.entity).isDeadOrDying();
    }

    @Override
    public boolean isEating() {
        return ((LivingEntity)this.entity).getUseItem().getUseAnimation() == UseAnim.EAT;
    }

    @Override
    public boolean isSleeping() {
        return ((LivingEntity)this.entity).isSleeping();
    }

    @Override
    public boolean isUsingItem() {
        return ((LivingEntity)this.entity).isUsingItem();
    }

    @Override
    public boolean isAutoSpinAttack() {
        return ((LivingEntity)this.entity).isAutoSpinAttack();
    }

    @Override
    public boolean isOnClimbable() {
        return ((LivingEntity)this.entity).onClimbable();
    }

    @Override
    public double usingItemDuration() {
        return (double)((LivingEntity)this.entity).getTicksUsingItem() / 20.0;
    }

    @Override
    public double usingItemMaxDuration() {
        ItemStack item = ((LivingEntity)this.entity).getUseItem();
        if (!item.isEmpty()) {
            return (double)item.getUseDuration((LivingEntity)this.entity) / 20.0;
        }
        return 0.0;
    }

    @Override
    public double usingItemRemainingDuration() {
        return (double)((LivingEntity)this.entity).getUseItemRemainingTicks() / 20.0;
    }

    @Override
    public int arrowCount() {
        return ((LivingEntity)this.entity).getArrowCount();
    }

    @Override
    public int stingerCount() {
        return ((LivingEntity)this.entity).getStingerCount();
    }

    @Override
    public double attributeValueByName(String name) {
        return AbstractRegistryManager.getAttribute((LivingEntity)this.entity, name);
    }

    @Override
    @Nullable
    public EffectSelector effectByName(String name) {
        MobEffectInstance effect = AbstractRegistryManager.getEffect((LivingEntity)this.entity, name);
        if (effect != null) {
            return this.effectSelector.apply(effect);
        }
        return null;
    }

    @Override
    @Nullable
    public ItemSelector equippedItemBySlot(String name) {
        Optional slot = NAMED_SLOTS.computeIfAbsent(name, LivingEntitySelectorImpl::findSlot);
        ItemStack itemStack = slot.map(it -> EquipmentItemProvider.getItemBySlot((LivingEntity)this.entity, it)).orElse(ItemStack.EMPTY);
        if (!itemStack.isEmpty()) {
            return this.itemSelector.apply(itemStack);
        }
        return null;
    }

    @Override
    public int equipmentCount() {
        int count = 0;
        for (OpenEquipmentSlot slot : OpenEquipmentSlot.values()) {
            ItemStack stack;
            if (slot == OpenEquipmentSlot.MAINHAND || slot == OpenEquipmentSlot.OFFHAND || (stack = EquipmentItemProvider.getItemBySlot((LivingEntity)this.entity, slot)).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int lastClimbableFacing() {
        Level level = PropertyProvider.getLevel(this.entity);
        if (level == null) {
            return 0;
        }
        Optional climbablePos = ((LivingEntity)this.entity).getLastClimbablePos();
        if (!climbablePos.isPresent()) {
            return 0;
        }
        BlockState blockState = level.getBlockState((BlockPos)climbablePos.get());
        Optional facing = blockState.getOptionalValue((Property)HorizontalDirectionalBlock.FACING);
        return facing.map(Direction::get2DDataValue).orElse(0);
    }

    private static Optional<OpenEquipmentSlot> findSlot(String name) {
        return Optional.ofNullable(FIXED_SLOTS.get(name.toLowerCase()));
    }
}

