/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind;

import moe.plushie.armourers_workshop.compatibility.core.AbstractRegistryManager;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.EntityInfoProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.data.EntityDataStorage;
import moe.plushie.armourers_workshop.core.skin.molang.core.Name;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.core.VariableStorage;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.MathHelper;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.BiomeSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.BlockSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.EntitySelector;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.BiomeSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.BlockSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ContextSelectorImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntitySelectorImpl<T extends Entity>
implements EntitySelector,
VariableStorage {
    protected T entity;
    protected VariableStorage variableStorage;
    protected ContextSelectorImpl contextSelector;
    private final BiomeSelectorImpl biomeSelector = new BiomeSelectorImpl();
    private final BlockSelectorImpl blockSelector = new BlockSelectorImpl();

    public EntitySelectorImpl<T> apply(T entity, ContextSelectorImpl contextSelector) {
        this.entity = entity;
        this.contextSelector = contextSelector;
        this.variableStorage = EntityDataStorage.of(entity).variableStorage().map(it -> it.get(contextSelector)).orElse(null);
        return this;
    }

    public T entity() {
        return this.entity;
    }

    @Override
    public double eyeYaw() {
        return this.entity.getViewXRot(this.partialTick());
    }

    @Override
    public double eyePitch() {
        return this.entity.getViewYRot(this.partialTick());
    }

    @Override
    public double headYaw() {
        return EntityInfoProvider.getHeadYaw(this.entity, this.partialTick());
    }

    @Override
    public double headPitch() {
        return EntityInfoProvider.getHeadPatch(this.entity, this.partialTick());
    }

    @Override
    public double x(double partialTicks) {
        return MathHelper.lerp(partialTicks, ((Entity)this.entity).xo, this.entity.getX());
    }

    @Override
    public double y(double partialTicks) {
        return MathHelper.lerp(partialTicks, ((Entity)this.entity).yo, this.entity.getY());
    }

    @Override
    public double z(double partialTicks) {
        return MathHelper.lerp(partialTicks, ((Entity)this.entity).zo, this.entity.getZ());
    }

    @Override
    public int cardinalFacing() {
        return this.entity.getDirection().get3DDataValue();
    }

    @Override
    public double distanceFromCamera() {
        return this.contextSelector.getCameraDistanceFormEntity((Entity)this.entity);
    }

    @Override
    public double distanceFromMove() {
        return ((Entity)this.entity).walkDist;
    }

    @Override
    public double distanceFromWalk() {
        return ((Entity)this.entity).moveDist;
    }

    @Override
    public double yawSpeed() {
        return 20.0f * (this.entity.getYRot() - ((Entity)this.entity).yRotO);
    }

    @Override
    public double groundSpeed() {
        Vec3 velocity = this.entity.getDeltaMovement();
        return 20.0 * Math.sqrt(velocity.x * velocity.x + velocity.z * velocity.z);
    }

    @Override
    public double verticalSpeed() {
        return 20.0 * (this.entity.position().y - ((Entity)this.entity).yo);
    }

    @Override
    public boolean isVehicle() {
        return this.entity.isVehicle();
    }

    @Override
    public boolean isPassenger() {
        return this.entity.isPassenger();
    }

    @Override
    public boolean isInWater() {
        return this.entity.isInWater();
    }

    @Override
    public boolean isInWaterRainOrBubble() {
        return this.entity.isInWaterRainOrBubble();
    }

    @Override
    public boolean isOnFire() {
        return this.entity.isOnFire();
    }

    @Override
    public boolean isOnGround() {
        return this.entity.onGround();
    }

    @Override
    public boolean isSneaking() {
        return this.entity.onGround() && this.entity.getPose() == Pose.CROUCHING;
    }

    @Override
    public boolean isJumping() {
        return !this.entity.isPassenger() && !this.entity.onGround() && !this.entity.isInWater();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.isSprinting();
    }

    @Override
    public boolean isSwimming() {
        return this.entity.isSwimming();
    }

    @Override
    public boolean isSleeping() {
        return this.entity.getPose() == Pose.SLEEPING;
    }

    @Override
    public boolean isSpectator() {
        return this.entity.isSpectator();
    }

    @Override
    public boolean isUnderWater() {
        return this.entity.isUnderWater();
    }

    @Override
    public boolean isCloseEyes() {
        if (this.isSleeping()) {
            return true;
        }
        double noise = (double)this.entity.getId() * 0.05;
        double time = (this.contextSelector.animationTicks() + noise) % 4.5;
        return time > 4.25;
    }

    @Override
    public boolean canSeeSky() {
        BlockPos pos;
        Level level = PropertyProvider.getLevel(this.entity);
        if (!level.canSeeSky(pos = this.entity.blockPosition())) {
            return false;
        }
        return level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() <= pos.getY();
    }

    @Override
    public double ticksFrozen() {
        return this.entity.getTicksFrozen();
    }

    @Override
    public double airSupply() {
        return this.entity.getAirSupply();
    }

    @Override
    @Nullable
    public BiomeSelector biome() {
        Level level = PropertyProvider.getLevel(this.entity);
        AbstractRegistryManager.Biome biome = AbstractRegistryManager.getBiome(level, this.entity.blockPosition());
        return this.biomeSelector.apply(biome);
    }

    @Override
    public BlockSelector relativeBlock(int offsetX, int offsetY, int offsetZ) {
        Level level = PropertyProvider.getLevel(this.entity);
        double x = this.entity.getX() + (double)offsetX;
        double y = this.entity.getX() + (double)offsetX;
        double z = this.entity.getX() + (double)offsetX;
        BlockState blockState = level.getBlockState(new BlockPos((int)x, (int)y, (int)z));
        return this.blockSelector.apply(blockState);
    }

    @Override
    public float partialTick() {
        return this.contextSelector.partialTick();
    }

    @Override
    public void setVariable(Name name, Result value) {
        this.variableStorage.setVariable(name, value);
    }

    @Override
    public Result getVariable(Name name) {
        return this.variableStorage.getVariable(name);
    }
}

