/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime.function;

import java.util.List;
import java.util.StringJoiner;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Optimizable;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;

public abstract class Function
implements Expression,
Optimizable {
    protected final Expression receiver;
    protected final List<Expression> arguments;

    protected Function(Expression receiver, int requirement, List<Expression> arguments) {
        this.receiver = receiver;
        this.arguments = arguments;
        if (arguments.size() < requirement) {
            throw new IllegalArgumentException(String.format("Function '%s' at least %s arguments. Only %s given!", receiver, requirement, arguments.size()));
        }
    }

    @Override
    public abstract double compute(ExecutionContext var1);

    @Override
    public Result evaluate(ExecutionContext context) {
        return Result.valueOf(this.compute(context));
    }

    @Override
    public boolean isMutable() {
        for (Expression argument : this.arguments) {
            if (!argument.isMutable()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (Expression arg : this.arguments) {
            joiner.add(arg.toString());
        }
        return this.receiver.toString() + String.valueOf(joiner);
    }

    public Expression receiver() {
        return this.receiver;
    }

    public List<Expression> arguments() {
        return this.arguments;
    }

    @FunctionalInterface
    public static interface Factory<T extends Function> {
        public T create(Expression var1, List<Expression> var2);
    }
}

