/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.attachment;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentPose;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentType;

public class SkinAttachmentContainer {
    private final Map<SkinAttachmentType, SkinAttachmentPose> fallbacks = new HashMap<SkinAttachmentType, SkinAttachmentPose>();
    private final Map<SkinAttachmentType, Int2ObjectMap<SkinAttachmentPose>> variants = new HashMap<SkinAttachmentType, Int2ObjectMap<SkinAttachmentPose>>();

    public void put(SkinAttachmentType attachmentType, int index, SkinAttachmentPose pose) {
        if (index < 0) {
            this.fallbacks.put(attachmentType, pose);
        } else {
            this.variants.computeIfAbsent(attachmentType, it -> new Int2ObjectOpenHashMap()).put(index, (Object)pose);
        }
    }

    public SkinAttachmentPose get(SkinAttachmentType attachmentType, int index) {
        SkinAttachmentPose value;
        Int2ObjectMap<SkinAttachmentPose> map = this.variants.get(attachmentType);
        if (map != null && (value = (SkinAttachmentPose)map.get(index)) != null) {
            return value;
        }
        return this.fallbacks.get(attachmentType);
    }

    public Int2ObjectMap<SkinAttachmentPose> get(SkinAttachmentType attachmentType) {
        return this.variants.get(attachmentType);
    }

    public void clear() {
        this.fallbacks.clear();
        this.variants.clear();
    }
}

